/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.ads.tag;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.ads.tag.AdsTag;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;

public class SymbolicAdsTag
implements AdsTag {
    private static final Pattern SYMBOLIC_ADDRESS_PATTERN = Pattern.compile("^(?<symbolicAddress>.+)");
    private final String symbolicAddress;
    private final PlcValueType dataType;
    private final List<ArrayInfo> arrayInfo;

    public SymbolicAdsTag(String symbolicAddress, PlcValueType dataType, List<ArrayInfo> arrayInfo) {
        this.symbolicAddress = Objects.requireNonNull(symbolicAddress);
        this.dataType = dataType;
        this.arrayInfo = arrayInfo;
    }

    public static SymbolicAdsTag of(String address) {
        Matcher matcher = SYMBOLIC_ADDRESS_PATTERN.matcher(address);
        if (!matcher.matches()) {
            throw new PlcInvalidTagException(address, SYMBOLIC_ADDRESS_PATTERN, "{address}");
        }
        String symbolicAddress = matcher.group("symbolicAddress");
        return new SymbolicAdsTag(symbolicAddress, null, null);
    }

    public static boolean matches(String address) {
        return SYMBOLIC_ADDRESS_PATTERN.matcher(address).matches();
    }

    public String getSymbolicAddress() {
        return this.symbolicAddress;
    }

    @Override
    public String getAddressString() {
        return this.symbolicAddress;
    }

    @Override
    public PlcValueType getPlcValueType() {
        return this.dataType;
    }

    @Override
    public List<ArrayInfo> getArrayInfo() {
        return this.arrayInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SymbolicAdsTag)) {
            return false;
        }
        SymbolicAdsTag that = (SymbolicAdsTag)o;
        return Objects.equals(this.symbolicAddress, that.symbolicAddress);
    }

    public int hashCode() {
        return Objects.hash(this.symbolicAddress);
    }

    public String toString() {
        return "SymbolicAdsTag{symbolicAddress='" + this.symbolicAddress + '\'' + '}';
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        writeBuffer.pushContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
        String symbolicAddress = this.getSymbolicAddress();
        writeBuffer.writeString("symbolicAddress", symbolicAddress.getBytes(StandardCharsets.UTF_8).length * 8, symbolicAddress, WithOption.WithEncoding(StandardCharsets.UTF_8.name()));
        writeBuffer.popContext(this.getClass().getSimpleName(), new WithWriterArgs[0]);
    }
}

