/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen;

import java.util.Optional;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.can.adapter.CANDriverAdapter;
import org.apache.plc4x.java.canopen.configuration.CANOpenConfiguration;
import org.apache.plc4x.java.canopen.context.CANOpenDriverContext;
import org.apache.plc4x.java.canopen.protocol.CANOpenProtocolLogic;
import org.apache.plc4x.java.canopen.readwrite.CANOpenFrame;
import org.apache.plc4x.java.canopen.tag.CANOpenTagHandler;
import org.apache.plc4x.java.canopen.transport.CANOpenFrameDataHandler;
import org.apache.plc4x.java.spi.configuration.ConfigurationFactory;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.connection.CustomProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.apache.plc4x.java.spi.optimizer.SingleTagOptimizer;
import org.apache.plc4x.java.spi.transport.Transport;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcValueHandler;
import org.apache.plc4x.java.transport.can.CANTransport;

public class CANOpenPlcDriver
extends GeneratedDriverBase<Message> {
    @Override
    public String getProtocolCode() {
        return "canopen";
    }

    @Override
    public String getProtocolName() {
        return "CAN open";
    }

    @Override
    protected boolean canRead() {
        return true;
    }

    @Override
    protected boolean canSubscribe() {
        return true;
    }

    @Override
    protected boolean canWrite() {
        return true;
    }

    @Override
    protected Class<? extends PlcConnectionConfiguration> getConfigurationClass() {
        return CANOpenConfiguration.class;
    }

    @Override
    protected Optional<String> getDefaultTransportCode() {
        return Optional.of("socketcan");
    }

    @Override
    protected CANOpenTagHandler getTagHandler() {
        return new CANOpenTagHandler();
    }

    @Override
    protected org.apache.plc4x.java.api.value.PlcValueHandler getValueHandler() {
        return new PlcValueHandler(){

            @Override
            public PlcValue newPlcValue(PlcTag tag, Object[] values) {
                if (values[0] instanceof PlcList) {
                    return (PlcList)values[0];
                }
                return super.newPlcValue(tag, values);
            }
        };
    }

    @Override
    protected boolean awaitDisconnectComplete() {
        return false;
    }

    @Override
    protected BaseOptimizer getOptimizer() {
        return new SingleTagOptimizer();
    }

    @Override
    protected ProtocolStackConfigurer<Message> getStackConfigurer() {
        throw new PlcRuntimeException("CANopen driver requires access to transport layer.");
    }

    @Override
    protected ProtocolStackConfigurer<Message> getStackConfigurer(Transport transport) {
        if (!(transport instanceof CANTransport)) {
            throw new PlcRuntimeException("CANopen driver requires a CAN transport instance");
        }
        CANTransport canTransport = (CANTransport)transport;
        return CustomProtocolStackConfigurer.builder(canTransport.getMessageType(), canTransport::getMessageInput).withProtocol(cfg -> {
            CANOpenProtocolLogic protocolLogic = new CANOpenProtocolLogic();
            ConfigurationFactory.configure(cfg, protocolLogic);
            return new CANDriverAdapter<Message, CANOpenFrame>(protocolLogic, canTransport.getMessageType(), canTransport.adapter(), new CANOpenFrameDataHandler(canTransport::getTransportFrameBuilder));
        }).withDriverContext(cfg -> new CANOpenDriverContext()).withPacketSizeEstimator(configuration1 -> canTransport.getEstimator()).littleEndian().build();
    }
}

