/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.api.conversation.canopen;

import io.vavr.control.Either;
import java.util.concurrent.CompletableFuture;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.canopen.api.conversation.canopen.CANConversation;
import org.apache.plc4x.java.canopen.api.conversation.canopen.CANOpenConversationBase;
import org.apache.plc4x.java.canopen.readwrite.CANOpenDataType;
import org.apache.plc4x.java.canopen.readwrite.CANOpenFrame;
import org.apache.plc4x.java.canopen.readwrite.CANOpenSDOResponse;
import org.apache.plc4x.java.canopen.readwrite.DataItem;
import org.apache.plc4x.java.canopen.readwrite.IndexAddress;
import org.apache.plc4x.java.canopen.readwrite.SDOAbort;
import org.apache.plc4x.java.canopen.readwrite.SDOAbortRequest;
import org.apache.plc4x.java.canopen.readwrite.SDOInitiateDownloadRequest;
import org.apache.plc4x.java.canopen.readwrite.SDOInitiateDownloadResponse;
import org.apache.plc4x.java.canopen.readwrite.SDOInitiateExpeditedUploadResponse;
import org.apache.plc4x.java.canopen.readwrite.SDOInitiateSegmentedUploadResponse;
import org.apache.plc4x.java.canopen.readwrite.SDOResponse;
import org.apache.plc4x.java.canopen.readwrite.SDOResponseCommand;
import org.apache.plc4x.java.canopen.readwrite.SDOSegmentDownloadRequest;
import org.apache.plc4x.java.canopen.readwrite.SDOSegmentDownloadResponse;
import org.apache.plc4x.java.canopen.transport.CANOpenAbortException;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;

public class SDODownloadConversation
extends CANOpenConversationBase {
    private final IndexAddress indexAddress;
    private final byte[] data;

    public SDODownloadConversation(CANConversation delegate, int nodeId, int answerNodeId, IndexAddress indexAddress, PlcValue value, CANOpenDataType type) {
        super(delegate, nodeId, answerNodeId);
        this.indexAddress = indexAddress;
        try {
            WriteBufferByteBased writeBuffer = new WriteBufferByteBased(DataItem.getLengthInBytes(value, type, null), ByteOrder.LITTLE_ENDIAN);
            DataItem.staticSerialize(writeBuffer, value, type, null, ByteOrder.LITTLE_ENDIAN);
            this.data = writeBuffer.getBytes();
        }
        catch (SerializationException e) {
            throw new PlcRuntimeException("Could not serialize data", e);
        }
    }

    public void execute(CompletableFuture<PlcResponseCode> receiver) {
        if (this.data.length > 4) {
            SDOInitiateSegmentedUploadResponse size = new SDOInitiateSegmentedUploadResponse(this.data.length);
            this.delegate.send(this.createFrame(new SDOInitiateDownloadRequest(false, true, this.indexAddress, size))).check(new CANOpenConversationBase.NodeIdPredicate(this.answerNodeId)).onTimeout(receiver::completeExceptionally).onError((response, error) -> {
                boolean bl = receiver.completeExceptionally((Throwable)error);
            }).unwrap(CANOpenFrame::getPayload).only(CANOpenSDOResponse.class).unwrap(CANOpenSDOResponse::getResponse).check(new CANOpenConversationBase.TypeOrAbortPredicate<SDOInitiateDownloadResponse>(SDOInitiateDownloadResponse.class)).unwrap(payload -> this.unwrap(SDOInitiateDownloadResponse.class, (SDOResponse)payload)).handle(either -> {
                if (either.isLeft()) {
                    receiver.completeExceptionally(new CANOpenAbortException("Could not initiate upload", ((SDOAbort)either.getLeft()).getCode()));
                } else {
                    SDOInitiateDownloadResponse response = (SDOInitiateDownloadResponse)either.get();
                    if (response.getAddress().equals(this.indexAddress)) {
                        this.put(this.data, receiver, false, 0);
                    } else {
                        SDOAbort abort = new SDOAbort(this.indexAddress, 1000L);
                        this.delegate.sendToWire(this.createFrame(new SDOAbortRequest(abort)));
                        receiver.complete(PlcResponseCode.REMOTE_ERROR);
                    }
                }
            });
            return;
        }
        SDOInitiateDownloadRequest rq = new SDOInitiateDownloadRequest(true, true, this.indexAddress, new SDOInitiateExpeditedUploadResponse(this.data));
        this.delegate.send(this.createFrame(rq)).check(new CANOpenConversationBase.NodeIdPredicate(this.answerNodeId)).onTimeout(receiver::completeExceptionally).unwrap(CANOpenFrame::getPayload).only(CANOpenSDOResponse.class).onError((response, error) -> this.onError(receiver, (CANOpenSDOResponse)response, (Throwable)error)).unwrap(CANOpenSDOResponse::getResponse).check(new CANOpenConversationBase.TypeOrAbortPredicate<SDOInitiateDownloadResponse>(SDOInitiateDownloadResponse.class)).unwrap(payload -> this.unwrap(SDOInitiateDownloadResponse.class, (SDOResponse)payload)).handle(either -> {
            if (either.isLeft()) {
                receiver.completeExceptionally(new CANOpenAbortException("Could not initiate upload", ((SDOAbort)either.getLeft()).getCode()));
            } else {
                SDOInitiateDownloadResponse response = (SDOInitiateDownloadResponse)either.get();
                if (response.getCommand() == SDOResponseCommand.INITIATE_DOWNLOAD) {
                    receiver.complete(PlcResponseCode.OK);
                } else {
                    receiver.complete(PlcResponseCode.REMOTE_ERROR);
                }
            }
        });
    }

    private void put(byte[] data, CompletableFuture<PlcResponseCode> receiver, boolean toggle, int offset) {
        int remaining = data.length - offset;
        byte[] segment = new byte[Math.min(remaining, 7)];
        System.arraycopy(data, offset, segment, 0, segment.length);
        this.delegate.send(this.createFrame(new SDOSegmentDownloadRequest(toggle, remaining <= 7, segment))).check(new CANOpenConversationBase.NodeIdPredicate(this.answerNodeId)).onTimeout(receiver::completeExceptionally).unwrap(CANOpenFrame::getPayload).only(CANOpenSDOResponse.class).onError((response, error) -> this.onError(receiver, (CANOpenSDOResponse)response, (Throwable)error)).unwrap(CANOpenSDOResponse::getResponse).check(new CANOpenConversationBase.TypeOrAbortPredicate<SDOSegmentDownloadResponse>(SDOSegmentDownloadResponse.class)).unwrap(payload -> this.unwrap(SDOSegmentDownloadResponse.class, (SDOResponse)payload)).check(sdoSegmentDownloadResponses -> !sdoSegmentDownloadResponses.isLeft()).unwrap(Either::get).handle(response -> {
            if (response.getToggle() != toggle) {
                receiver.complete(PlcResponseCode.REMOTE_ERROR);
                return;
            }
            if (offset + segment.length == data.length) {
                receiver.complete(PlcResponseCode.OK);
            } else {
                this.put(data, receiver, !toggle, offset + segment.length);
            }
        });
    }
}

