/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.canopen.readwrite.CANOpenPayload;
import org.apache.plc4x.java.canopen.readwrite.CANOpenService;
import org.apache.plc4x.java.canopen.readwrite.SDORequest;
import org.apache.plc4x.java.canopen.readwrite.SDORequestCommand;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class CANOpenSDORequest
extends CANOpenPayload
implements Message {
    protected final SDORequestCommand command;
    protected final SDORequest request;

    @Override
    public CANOpenService getService() {
        return CANOpenService.RECEIVE_SDO;
    }

    public CANOpenSDORequest(SDORequestCommand command, SDORequest request) {
        this.command = command;
        this.request = request;
    }

    public SDORequestCommand getCommand() {
        return this.command;
    }

    public SDORequest getRequest() {
        return this.request;
    }

    @Override
    protected void serializeCANOpenPayloadChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CANOpenSDORequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField("command", "SDORequestCommand", this.command, new DataWriterEnumDefault<SDORequestCommand, Byte>(SDORequestCommand::getValue, Enum::name, DataWriterFactory.writeUnsignedByte(writeBuffer, 3)), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("request", this.request, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("CANOpenSDORequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        CANOpenSDORequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 3;
        return lengthInBits += this.request.getLengthInBits();
    }

    public static CANOpenPayload.CANOpenPayloadBuilder staticParseCANOpenPayloadBuilder(ReadBuffer readBuffer, CANOpenService service) throws ParseException {
        readBuffer.pullContext("CANOpenSDORequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        SDORequestCommand command = (SDORequestCommand)((Object)FieldReaderFactory.readEnumField("command", "SDORequestCommand", new DataReaderEnumDefault<SDORequestCommand, Byte>(SDORequestCommand::enumForValue, DataReaderFactory.readUnsignedByte(readBuffer, 3)), new WithReaderArgs[0]));
        SDORequest request = FieldReaderFactory.readSimpleField("request", new DataReaderComplexDefault<SDORequest>(() -> SDORequest.staticParse(readBuffer, command), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("CANOpenSDORequest", new WithReaderArgs[0]);
        return new CANOpenSDORequestBuilderImpl(command, request);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CANOpenSDORequest)) {
            return false;
        }
        CANOpenSDORequest that = (CANOpenSDORequest)o;
        return this.getCommand() == that.getCommand() && this.getRequest() == that.getRequest() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getCommand(), this.getRequest()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CANOpenSDORequestBuilderImpl
    implements CANOpenPayload.CANOpenPayloadBuilder {
        private final SDORequestCommand command;
        private final SDORequest request;

        public CANOpenSDORequestBuilderImpl(SDORequestCommand command, SDORequest request) {
            this.command = command;
            this.request = request;
        }

        @Override
        public CANOpenSDORequest build() {
            CANOpenSDORequest cANOpenSDORequest = new CANOpenSDORequest(this.command, this.request);
            return cANOpenSDORequest;
        }
    }
}

