/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.canopen.readwrite.IndexAddress;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class SDOSegment
implements Message {
    protected final boolean expedited;
    protected final boolean indicated;
    protected final IndexAddress address;
    protected final byte[] data;

    public SDOSegment(boolean expedited, boolean indicated, IndexAddress address, byte[] data) {
        this.expedited = expedited;
        this.indicated = indicated;
        this.address = address;
        this.data = data;
    }

    public boolean getExpedited() {
        return this.expedited;
    }

    public boolean getIndicated() {
        return this.indicated;
    }

    public IndexAddress getAddress() {
        return this.address;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("SDOSegment", new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField("reserved", (byte)0, DataWriterFactory.writeUnsignedByte(writeBuffer, 1), new WithWriterArgs[0]);
        byte size = (byte)(this.getExpedited() && this.getIndicated() ? 4 - StaticHelper.COUNT(this.getData()) : 0);
        FieldWriterFactory.writeImplicitField("size", size, DataWriterFactory.writeUnsignedByte(writeBuffer, 2), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("expedited", this.expedited, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("indicated", this.indicated, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("address", this.address, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField("data", this.data, DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writePaddingField("padding", 4 - StaticHelper.COUNT(this.data), (short)0, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        writeBuffer.popContext("SDOSegment", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        SDOSegment _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ++lengthInBits;
        lengthInBits += 2;
        ++lengthInBits;
        ++lengthInBits;
        lengthInBits += this.address.getLengthInBits();
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        int _timesPadding = 4 - StaticHelper.COUNT(this.data);
        while (_timesPadding-- > 0) {
            lengthInBits += 8;
        }
        return lengthInBits;
    }

    public static SDOSegment staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return SDOSegment.staticParse(readBuffer);
    }

    public static SDOSegment staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("SDOSegment", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        Byte reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 1), (byte)0, new WithReaderArgs[0]);
        byte size = FieldReaderFactory.readImplicitField("size", DataReaderFactory.readUnsignedByte(readBuffer, 2), new WithReaderArgs[0]);
        boolean expedited = FieldReaderFactory.readSimpleField("expedited", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
        boolean indicated = FieldReaderFactory.readSimpleField("indicated", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
        IndexAddress address = FieldReaderFactory.readSimpleField("address", new DataReaderComplexDefault<IndexAddress>(() -> IndexAddress.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(expedited && indicated ? 4 - size : 0), new WithReaderArgs[0]);
        FieldReaderFactory.readPaddingField(DataReaderFactory.readUnsignedShort(readBuffer, 8), 4 - StaticHelper.COUNT(data), new WithReaderArgs[0]);
        readBuffer.closeContext("SDOSegment", new WithReaderArgs[0]);
        SDOSegment _sDOSegment = new SDOSegment(expedited, indicated, address, data);
        return _sDOSegment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SDOSegment)) {
            return false;
        }
        SDOSegment that = (SDOSegment)o;
        return this.getExpedited() == that.getExpedited() && this.getIndicated() == that.getIndicated() && this.getAddress() == that.getAddress() && this.getData() == that.getData();
    }

    public int hashCode() {
        return Objects.hash(this.getExpedited(), this.getIndicated(), this.getAddress(), this.getData());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

