/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.eip.readwrite.CipService;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class CipConnectedRequest
extends CipService
implements Message {
    protected final byte[] pathSegments;

    @Override
    public Byte getService() {
        return (byte)82;
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    @Override
    public Boolean getConnected() {
        return true;
    }

    public CipConnectedRequest(byte[] pathSegments) {
        this.pathSegments = pathSegments;
    }

    public byte[] getPathSegments() {
        return this.pathSegments;
    }

    @Override
    protected void serializeCipServiceChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CipConnectedRequest", new WithWriterArgs[0]);
        short requestPathSize = (short)(StaticHelper.COUNT(this.getPathSegments()) / 2);
        FieldWriterFactory.writeImplicitField("requestPathSize", requestPathSize, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField("pathSegments", this.pathSegments, DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField("reserved", 1, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField("reserved", 0L, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        writeBuffer.popContext("CipConnectedRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        CipConnectedRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        if (this.pathSegments != null) {
            lengthInBits += 8 * this.pathSegments.length;
        }
        lengthInBits += 16;
        return lengthInBits += 32;
    }

    public static CipService.CipServiceBuilder staticParseCipServiceBuilder(ReadBuffer readBuffer, Boolean connected, Integer serviceLen) throws ParseException {
        readBuffer.pullContext("CipConnectedRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        short requestPathSize = FieldReaderFactory.readImplicitField("requestPathSize", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
        byte[] pathSegments = readBuffer.readByteArray("pathSegments", Math.toIntExact(requestPathSize * 2), new WithReaderArgs[0]);
        Integer reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedInt(readBuffer, 16), 1, new WithReaderArgs[0]);
        Long reservedField1 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedLong(readBuffer, 32), 0L, new WithReaderArgs[0]);
        readBuffer.closeContext("CipConnectedRequest", new WithReaderArgs[0]);
        return new CipConnectedRequestBuilderImpl(pathSegments);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CipConnectedRequest)) {
            return false;
        }
        CipConnectedRequest that = (CipConnectedRequest)o;
        return this.getPathSegments() == that.getPathSegments() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getPathSegments());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CipConnectedRequestBuilderImpl
    implements CipService.CipServiceBuilder {
        private final byte[] pathSegments;

        public CipConnectedRequestBuilderImpl(byte[] pathSegments) {
            this.pathSegments = pathSegments;
        }

        @Override
        public CipConnectedRequest build() {
            CipConnectedRequest cipConnectedRequest = new CipConnectedRequest(this.pathSegments);
            return cipConnectedRequest;
        }
    }
}

