/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.eip.readwrite.CipService;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class CipReadRequest
extends CipService
implements Message {
    protected final byte[] tag;
    protected final int elementNb;

    @Override
    public Byte getService() {
        return (byte)76;
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    @Override
    public Boolean getConnected() {
        return false;
    }

    public CipReadRequest(byte[] tag, int elementNb) {
        this.tag = tag;
        this.elementNb = elementNb;
    }

    public byte[] getTag() {
        return this.tag;
    }

    public int getElementNb() {
        return this.elementNb;
    }

    @Override
    protected void serializeCipServiceChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CipReadRequest", new WithWriterArgs[0]);
        short requestPathSize = (short)(StaticHelper.COUNT(this.getTag()) / 2);
        FieldWriterFactory.writeImplicitField("requestPathSize", requestPathSize, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField("tag", this.tag, DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("elementNb", this.elementNb, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        writeBuffer.popContext("CipReadRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        CipReadRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        if (this.tag != null) {
            lengthInBits += 8 * this.tag.length;
        }
        return lengthInBits += 16;
    }

    public static CipService.CipServiceBuilder staticParseCipServiceBuilder(ReadBuffer readBuffer, Boolean connected, Integer serviceLen) throws ParseException {
        readBuffer.pullContext("CipReadRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        short requestPathSize = FieldReaderFactory.readImplicitField("requestPathSize", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
        byte[] tag = readBuffer.readByteArray("tag", Math.toIntExact(requestPathSize * 2), new WithReaderArgs[0]);
        int elementNb = FieldReaderFactory.readSimpleField("elementNb", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        readBuffer.closeContext("CipReadRequest", new WithReaderArgs[0]);
        return new CipReadRequestBuilderImpl(tag, elementNb);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CipReadRequest)) {
            return false;
        }
        CipReadRequest that = (CipReadRequest)o;
        return this.getTag() == that.getTag() && this.getElementNb() == that.getElementNb() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTag(), this.getElementNb());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CipReadRequestBuilderImpl
    implements CipService.CipServiceBuilder {
        private final byte[] tag;
        private final int elementNb;

        public CipReadRequestBuilderImpl(byte[] tag, int elementNb) {
            this.tag = tag;
            this.elementNb = elementNb;
        }

        @Override
        public CipReadRequest build() {
            CipReadRequest cipReadRequest = new CipReadRequest(this.tag, this.elementNb);
            return cipReadRequest;
        }
    }
}

