/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.eip.readwrite.CipConnectedRequest;
import org.apache.plc4x.java.eip.readwrite.CipConnectedResponse;
import org.apache.plc4x.java.eip.readwrite.CipConnectionManagerCloseRequest;
import org.apache.plc4x.java.eip.readwrite.CipConnectionManagerCloseResponse;
import org.apache.plc4x.java.eip.readwrite.CipConnectionManagerRequest;
import org.apache.plc4x.java.eip.readwrite.CipConnectionManagerResponse;
import org.apache.plc4x.java.eip.readwrite.CipReadRequest;
import org.apache.plc4x.java.eip.readwrite.CipReadResponse;
import org.apache.plc4x.java.eip.readwrite.CipUnconnectedRequest;
import org.apache.plc4x.java.eip.readwrite.CipWriteRequest;
import org.apache.plc4x.java.eip.readwrite.CipWriteResponse;
import org.apache.plc4x.java.eip.readwrite.GetAttributeAllRequest;
import org.apache.plc4x.java.eip.readwrite.GetAttributeAllResponse;
import org.apache.plc4x.java.eip.readwrite.GetAttributeListRequest;
import org.apache.plc4x.java.eip.readwrite.GetAttributeListResponse;
import org.apache.plc4x.java.eip.readwrite.GetAttributeSingleRequest;
import org.apache.plc4x.java.eip.readwrite.GetAttributeSingleResponse;
import org.apache.plc4x.java.eip.readwrite.MultipleServiceRequest;
import org.apache.plc4x.java.eip.readwrite.MultipleServiceResponse;
import org.apache.plc4x.java.eip.readwrite.SetAttributeAllRequest;
import org.apache.plc4x.java.eip.readwrite.SetAttributeAllResponse;
import org.apache.plc4x.java.eip.readwrite.SetAttributeListRequest;
import org.apache.plc4x.java.eip.readwrite.SetAttributeListResponse;
import org.apache.plc4x.java.eip.readwrite.SetAttributeSingleRequest;
import org.apache.plc4x.java.eip.readwrite.SetAttributeSingleResponse;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public abstract class CipService
implements Message {
    public abstract Boolean getConnected();

    public abstract Boolean getResponse();

    public abstract Byte getService();

    protected abstract void serializeCipServiceChild(WriteBuffer var1) throws SerializationException;

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CipService", new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorField("response", this.getResponse(), DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorField("service", this.getService(), DataWriterFactory.writeUnsignedByte(writeBuffer, 7), new WithWriterArgs[0]);
        this.serializeCipServiceChild(writeBuffer);
        writeBuffer.popContext("CipService", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        CipService _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ++lengthInBits;
        return lengthInBits += 7;
    }

    public static CipService staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Integer serviceLen;
        Boolean connected;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 2) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 2, but got " + args.length);
        }
        if (args[0] instanceof Boolean) {
            connected = (Boolean)args[0];
        } else if (args[0] instanceof String) {
            connected = Boolean.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Boolean or a string which is parseable but was " + args[0].getClass().getName());
        }
        if (args[1] instanceof Integer) {
            serviceLen = (Integer)args[1];
        } else if (args[1] instanceof String) {
            serviceLen = Integer.valueOf((String)args[1]);
        } else {
            throw new PlcRuntimeException("Argument 1 expected to be of type Integer or a string which is parseable but was " + args[1].getClass().getName());
        }
        return CipService.staticParse(readBuffer, connected, serviceLen);
    }

    public static CipService staticParse(ReadBuffer readBuffer, Boolean connected, Integer serviceLen) throws ParseException {
        readBuffer.pullContext("CipService", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        boolean response = FieldReaderFactory.readDiscriminatorField("response", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
        byte service = FieldReaderFactory.readDiscriminatorField("service", DataReaderFactory.readUnsignedByte(readBuffer, 7), new WithReaderArgs[0]);
        CipServiceBuilder builder = null;
        if (EvaluationHelper.equals(service, (byte)1) && EvaluationHelper.equals(response, false)) {
            builder = GetAttributeAllRequest.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)1) && EvaluationHelper.equals(response, true)) {
            builder = GetAttributeAllResponse.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)2) && EvaluationHelper.equals(response, false)) {
            builder = SetAttributeAllRequest.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)2) && EvaluationHelper.equals(response, true)) {
            builder = SetAttributeAllResponse.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)3) && EvaluationHelper.equals(response, false)) {
            builder = GetAttributeListRequest.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)3) && EvaluationHelper.equals(response, true)) {
            builder = GetAttributeListResponse.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)4) && EvaluationHelper.equals(response, false)) {
            builder = SetAttributeListRequest.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)4) && EvaluationHelper.equals(response, true)) {
            builder = SetAttributeListResponse.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)10) && EvaluationHelper.equals(response, false)) {
            builder = MultipleServiceRequest.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)10) && EvaluationHelper.equals(response, true)) {
            builder = MultipleServiceResponse.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)14) && EvaluationHelper.equals(response, false)) {
            builder = GetAttributeSingleRequest.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)14) && EvaluationHelper.equals(response, true)) {
            builder = GetAttributeSingleResponse.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)16) && EvaluationHelper.equals(response, false)) {
            builder = SetAttributeSingleRequest.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)16) && EvaluationHelper.equals(response, true)) {
            builder = SetAttributeSingleResponse.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)76) && EvaluationHelper.equals(response, false)) {
            builder = CipReadRequest.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)76) && EvaluationHelper.equals(response, true)) {
            builder = CipReadResponse.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)77) && EvaluationHelper.equals(response, false)) {
            builder = CipWriteRequest.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)77) && EvaluationHelper.equals(response, true)) {
            builder = CipWriteResponse.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)78) && EvaluationHelper.equals(response, false)) {
            builder = CipConnectionManagerCloseRequest.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)78) && EvaluationHelper.equals(response, true)) {
            builder = CipConnectionManagerCloseResponse.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)82) && EvaluationHelper.equals(response, false) && EvaluationHelper.equals(connected, false)) {
            builder = CipUnconnectedRequest.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)82) && EvaluationHelper.equals(response, false) && EvaluationHelper.equals(connected, true)) {
            builder = CipConnectedRequest.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)82) && EvaluationHelper.equals(response, true)) {
            builder = CipConnectedResponse.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)91) && EvaluationHelper.equals(response, false)) {
            builder = CipConnectionManagerRequest.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        } else if (EvaluationHelper.equals(service, (byte)91) && EvaluationHelper.equals(response, true)) {
            builder = CipConnectionManagerResponse.staticParseCipServiceBuilder(readBuffer, connected, serviceLen);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [service=" + service + " " + "response=" + response + " " + "connected=" + connected + "]");
        }
        readBuffer.closeContext("CipService", new WithReaderArgs[0]);
        CipService _cipService = builder.build();
        return _cipService;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CipService)) {
            return false;
        }
        CipService that = (CipService)o;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface CipServiceBuilder {
        public CipService build();
    }
}

