/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.eip.readwrite.CipService;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class Services
implements Message {
    protected final List<Integer> offsets;
    protected final List<CipService> services;

    public Services(List<Integer> offsets, List<CipService> services) {
        this.offsets = offsets;
        this.services = services;
    }

    public List<Integer> getOffsets() {
        return this.offsets;
    }

    public List<CipService> getServices() {
        return this.services;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("Services", new WithWriterArgs[0]);
        int serviceNb = StaticHelper.COUNT(this.getOffsets());
        FieldWriterFactory.writeImplicitField("serviceNb", serviceNb, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField("offsets", this.offsets, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("services", this.services, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("Services", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        Services _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        if (this.offsets != null) {
            lengthInBits += 16 * this.offsets.size();
        }
        if (this.services != null) {
            int i = 0;
            for (CipService element : this.services) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.services.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static Services staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Integer servicesLen;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Integer) {
            servicesLen = (Integer)args[0];
        } else if (args[0] instanceof String) {
            servicesLen = Integer.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Integer or a string which is parseable but was " + args[0].getClass().getName());
        }
        return Services.staticParse(readBuffer, servicesLen);
    }

    public static Services staticParse(ReadBuffer readBuffer, Integer servicesLen) throws ParseException {
        readBuffer.pullContext("Services", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int serviceNb = FieldReaderFactory.readImplicitField("serviceNb", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        List<Integer> offsets = FieldReaderFactory.readCountArrayField("offsets", DataReaderFactory.readUnsignedInt(readBuffer, 16), serviceNb, new WithReaderArgs[0]);
        List<CipService> services = FieldReaderFactory.readCountArrayField("services", new DataReaderComplexDefault<CipService>(() -> CipService.staticParse(readBuffer, false, servicesLen / serviceNb), readBuffer), serviceNb, new WithReaderArgs[0]);
        readBuffer.closeContext("Services", new WithReaderArgs[0]);
        Services _services = new Services(offsets, services);
        return _services;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Services)) {
            return false;
        }
        Services that = (Services)o;
        return this.getOffsets() == that.getOffsets() && this.getServices() == that.getServices();
    }

    public int hashCode() {
        return Objects.hash(this.getOffsets(), this.getServices());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

