/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.eip.readwrite.TypeId;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class ServicesResponse
extends TypeId
implements Message {
    protected final int encapsulationProtocol;
    protected final boolean supportsCIPEncapsulation;
    protected final boolean supportsUDP;
    protected final byte[] data;

    @Override
    public Integer getId() {
        return 256;
    }

    public ServicesResponse(int encapsulationProtocol, boolean supportsCIPEncapsulation, boolean supportsUDP, byte[] data) {
        this.encapsulationProtocol = encapsulationProtocol;
        this.supportsCIPEncapsulation = supportsCIPEncapsulation;
        this.supportsUDP = supportsUDP;
        this.data = data;
    }

    public int getEncapsulationProtocol() {
        return this.encapsulationProtocol;
    }

    public boolean getSupportsCIPEncapsulation() {
        return this.supportsCIPEncapsulation;
    }

    public boolean getSupportsUDP() {
        return this.supportsUDP;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    protected void serializeTypeIdChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ServicesResponse", new WithWriterArgs[0]);
        int serviceLen = this.getLengthInBytes() - 4;
        FieldWriterFactory.writeImplicitField("serviceLen", serviceLen, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("encapsulationProtocol", this.encapsulationProtocol, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField("reserved", (byte)0, DataWriterFactory.writeUnsignedByte(writeBuffer, 2), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("supportsCIPEncapsulation", this.supportsCIPEncapsulation, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField("reserved", (short)0, DataWriterFactory.writeUnsignedShort(writeBuffer, 12), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("supportsUDP", this.supportsUDP, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField("data", this.data, DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        writeBuffer.popContext("ServicesResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ServicesResponse _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        lengthInBits += 16;
        lengthInBits += 2;
        ++lengthInBits;
        lengthInBits += 12;
        ++lengthInBits;
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        return lengthInBits;
    }

    public static TypeId.TypeIdBuilder staticParseTypeIdBuilder(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("ServicesResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int serviceLen = FieldReaderFactory.readImplicitField("serviceLen", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        int encapsulationProtocol = FieldReaderFactory.readSimpleField("encapsulationProtocol", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        Byte reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 2), (byte)0, new WithReaderArgs[0]);
        boolean supportsCIPEncapsulation = FieldReaderFactory.readSimpleField("supportsCIPEncapsulation", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
        Short reservedField1 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedShort(readBuffer, 12), (short)0, new WithReaderArgs[0]);
        boolean supportsUDP = FieldReaderFactory.readSimpleField("supportsUDP", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(serviceLen - 4), new WithReaderArgs[0]);
        readBuffer.closeContext("ServicesResponse", new WithReaderArgs[0]);
        return new ServicesResponseBuilderImpl(encapsulationProtocol, supportsCIPEncapsulation, supportsUDP, data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServicesResponse)) {
            return false;
        }
        ServicesResponse that = (ServicesResponse)o;
        return this.getEncapsulationProtocol() == that.getEncapsulationProtocol() && this.getSupportsCIPEncapsulation() == that.getSupportsCIPEncapsulation() && this.getSupportsUDP() == that.getSupportsUDP() && this.getData() == that.getData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getEncapsulationProtocol(), this.getSupportsCIPEncapsulation(), this.getSupportsUDP(), this.getData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ServicesResponseBuilderImpl
    implements TypeId.TypeIdBuilder {
        private final int encapsulationProtocol;
        private final boolean supportsCIPEncapsulation;
        private final boolean supportsUDP;
        private final byte[] data;

        public ServicesResponseBuilderImpl(int encapsulationProtocol, boolean supportsCIPEncapsulation, boolean supportsUDP, byte[] data) {
            this.encapsulationProtocol = encapsulationProtocol;
            this.supportsCIPEncapsulation = supportsCIPEncapsulation;
            this.supportsUDP = supportsUDP;
            this.data = data;
        }

        @Override
        public ServicesResponse build() {
            ServicesResponse servicesResponse = new ServicesResponse(this.encapsulationProtocol, this.supportsCIPEncapsulation, this.supportsUDP, this.data);
            return servicesResponse;
        }
    }
}

