/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.firmata.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.firmata.readwrite.FirmataCommandProtocolVersion;
import org.apache.plc4x.java.firmata.readwrite.FirmataCommandSetDigitalPinValue;
import org.apache.plc4x.java.firmata.readwrite.FirmataCommandSetPinMode;
import org.apache.plc4x.java.firmata.readwrite.FirmataCommandSysex;
import org.apache.plc4x.java.firmata.readwrite.FirmataCommandSystemReset;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public abstract class FirmataCommand
implements Message {
    public abstract Byte getCommandCode();

    protected abstract void serializeFirmataCommandChild(WriteBuffer var1) throws SerializationException;

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("FirmataCommand", new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorField("commandCode", this.getCommandCode(), DataWriterFactory.writeUnsignedByte(writeBuffer, 4), new WithWriterArgs[0]);
        this.serializeFirmataCommandChild(writeBuffer);
        writeBuffer.popContext("FirmataCommand", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        FirmataCommand _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits += 4;
    }

    public static FirmataCommand staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Boolean response;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Boolean) {
            response = (Boolean)args[0];
        } else if (args[0] instanceof String) {
            response = Boolean.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Boolean or a string which is parseable but was " + args[0].getClass().getName());
        }
        return FirmataCommand.staticParse(readBuffer, response);
    }

    public static FirmataCommand staticParse(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("FirmataCommand", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        byte commandCode = FieldReaderFactory.readDiscriminatorField("commandCode", DataReaderFactory.readUnsignedByte(readBuffer, 4), new WithReaderArgs[0]);
        FirmataCommandBuilder builder = null;
        if (EvaluationHelper.equals(commandCode, (byte)0)) {
            builder = FirmataCommandSysex.staticParseFirmataCommandBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals(commandCode, (byte)4)) {
            builder = FirmataCommandSetPinMode.staticParseFirmataCommandBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals(commandCode, (byte)5)) {
            builder = FirmataCommandSetDigitalPinValue.staticParseFirmataCommandBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals(commandCode, (byte)9)) {
            builder = FirmataCommandProtocolVersion.staticParseFirmataCommandBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals(commandCode, (byte)15)) {
            builder = FirmataCommandSystemReset.staticParseFirmataCommandBuilder(readBuffer, response);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [commandCode=" + commandCode + "]");
        }
        readBuffer.closeContext("FirmataCommand", new WithReaderArgs[0]);
        FirmataCommand _firmataCommand = builder.build();
        return _firmataCommand;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FirmataCommand)) {
            return false;
        }
        FirmataCommand that = (FirmataCommand)o;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface FirmataCommandBuilder {
        public FirmataCommand build();
    }
}

