/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.firmata.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.firmata.readwrite.FirmataMessage;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class FirmataMessageDigitalIO
extends FirmataMessage
implements Message {
    protected final byte pinBlock;
    protected final List<Byte> data;

    @Override
    public Byte getMessageType() {
        return (byte)9;
    }

    public FirmataMessageDigitalIO(byte pinBlock, List<Byte> data) {
        this.pinBlock = pinBlock;
        this.data = data;
    }

    public byte getPinBlock() {
        return this.pinBlock;
    }

    public List<Byte> getData() {
        return this.data;
    }

    @Override
    protected void serializeFirmataMessageChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("FirmataMessageDigitalIO", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("pinBlock", this.pinBlock, DataWriterFactory.writeUnsignedByte(writeBuffer, 4), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        FieldWriterFactory.writeSimpleTypeArrayField("data", this.data, DataWriterFactory.writeSignedByte(writeBuffer, 8), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        writeBuffer.popContext("FirmataMessageDigitalIO", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        FirmataMessageDigitalIO _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 4;
        if (this.data != null) {
            lengthInBits += 8 * this.data.size();
        }
        return lengthInBits;
    }

    public static FirmataMessage.FirmataMessageBuilder staticParseFirmataMessageBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("FirmataMessageDigitalIO", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        byte pinBlock = FieldReaderFactory.readSimpleField("pinBlock", DataReaderFactory.readUnsignedByte(readBuffer, 4), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        List<Byte> data = FieldReaderFactory.readCountArrayField("data", DataReaderFactory.readSignedByte(readBuffer, 8), 2L, WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        readBuffer.closeContext("FirmataMessageDigitalIO", new WithReaderArgs[0]);
        return new FirmataMessageDigitalIOBuilderImpl(pinBlock, data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FirmataMessageDigitalIO)) {
            return false;
        }
        FirmataMessageDigitalIO that = (FirmataMessageDigitalIO)o;
        return this.getPinBlock() == that.getPinBlock() && this.getData() == that.getData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getPinBlock(), this.getData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class FirmataMessageDigitalIOBuilderImpl
    implements FirmataMessage.FirmataMessageBuilder {
        private final byte pinBlock;
        private final List<Byte> data;

        public FirmataMessageDigitalIOBuilderImpl(byte pinBlock, List<Byte> data) {
            this.pinBlock = pinBlock;
            this.data = data;
        }

        @Override
        public FirmataMessageDigitalIO build() {
            FirmataMessageDigitalIO firmataMessageDigitalIO = new FirmataMessageDigitalIO(this.pinBlock, this.data);
            return firmataMessageDigitalIO;
        }
    }
}

