/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.genericcan.readwrite;

import java.math.BigInteger;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.genericcan.readwrite.GenericCANDataType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcBYTE;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcULINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataItem.class);

    public static PlcValue staticParse(ReadBuffer readBuffer, GenericCANDataType dataType) throws ParseException {
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.BYTE)) {
            byte value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readByte(readBuffer, 8), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
            return new PlcBYTE((short)value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.BOOLEAN)) {
            boolean value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readBoolean(readBuffer), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED8)) {
            short value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedShort(readBuffer, 8), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED16)) {
            int value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedInt(readBuffer, 16), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED24)) {
            int value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedInt(readBuffer, 24), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
            return new PlcUDINT((long)value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED32)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedLong(readBuffer, 32), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED40)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedLong(readBuffer, 40), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED48)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedLong(readBuffer, 48), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED56)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedLong(readBuffer, 56), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED64)) {
            BigInteger value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedBigInteger(readBuffer, 64), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
            return new PlcULINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER8)) {
            byte value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedByte(readBuffer, 8), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER16)) {
            short value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedShort(readBuffer, 16), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER24)) {
            int value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedInt(readBuffer, 24), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER32)) {
            int value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedInt(readBuffer, 32), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER40)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedLong(readBuffer, 40), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER48)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedLong(readBuffer, 48), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER56)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedLong(readBuffer, 56), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER64)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedLong(readBuffer, 64), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
            return new PlcLINT(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.REAL32)) {
            float value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readFloat(readBuffer, 32), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN)).floatValue();
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.REAL64)) {
            double value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readDouble(readBuffer, 64), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
            return new PlcLREAL(value);
        }
        return null;
    }

    public static int getLengthInBytes(PlcValue _value, GenericCANDataType dataType) {
        return (int)Math.ceil((double)DataItem.getLengthInBits(_value, dataType) / 8.0);
    }

    public static int getLengthInBits(PlcValue _value, GenericCANDataType dataType) {
        int lengthInBits = 0;
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.BYTE)) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.BOOLEAN)) {
            ++lengthInBits;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED8)) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED16)) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED24)) {
            lengthInBits += 24;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED32)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED40)) {
            lengthInBits += 40;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED48)) {
            lengthInBits += 48;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED56)) {
            lengthInBits += 56;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED64)) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER8)) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER16)) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER24)) {
            lengthInBits += 24;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER32)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER40)) {
            lengthInBits += 40;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER48)) {
            lengthInBits += 48;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER56)) {
            lengthInBits += 56;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER64)) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.REAL32)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.REAL64)) {
            lengthInBits += 64;
        }
        return lengthInBits;
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, GenericCANDataType dataType) throws SerializationException {
        DataItem.staticSerialize(writeBuffer, _value, dataType, ByteOrder.BIG_ENDIAN);
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, GenericCANDataType dataType, ByteOrder byteOrder) throws SerializationException {
        if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.BYTE)) {
            FieldWriterFactory.writeSimpleField("value", _value.getByte(), DataWriterFactory.writeByte(writeBuffer, 8), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.BOOLEAN)) {
            FieldWriterFactory.writeSimpleField("value", _value.getBoolean(), DataWriterFactory.writeBoolean(writeBuffer), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED8)) {
            FieldWriterFactory.writeSimpleField("value", _value.getShort(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED16)) {
            FieldWriterFactory.writeSimpleField("value", _value.getInteger(), DataWriterFactory.writeUnsignedInt(writeBuffer, 16), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED24)) {
            FieldWriterFactory.writeSimpleField("value", _value.getInteger(), DataWriterFactory.writeUnsignedInt(writeBuffer, 24), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED32)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeUnsignedLong(writeBuffer, 32), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED40)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeUnsignedLong(writeBuffer, 40), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED48)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeUnsignedLong(writeBuffer, 48), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED56)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeUnsignedLong(writeBuffer, 56), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.UNSIGNED64)) {
            FieldWriterFactory.writeSimpleField("value", _value.getBigInteger(), DataWriterFactory.writeUnsignedBigInteger(writeBuffer, 64), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER8)) {
            FieldWriterFactory.writeSimpleField("value", _value.getByte(), DataWriterFactory.writeSignedByte(writeBuffer, 8), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER16)) {
            FieldWriterFactory.writeSimpleField("value", _value.getShort(), DataWriterFactory.writeSignedShort(writeBuffer, 16), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER24)) {
            FieldWriterFactory.writeSimpleField("value", _value.getInteger(), DataWriterFactory.writeSignedInt(writeBuffer, 24), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER32)) {
            FieldWriterFactory.writeSimpleField("value", _value.getInteger(), DataWriterFactory.writeSignedInt(writeBuffer, 32), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER40)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeSignedLong(writeBuffer, 40), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER48)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeSignedLong(writeBuffer, 48), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER56)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeSignedLong(writeBuffer, 56), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.INTEGER64)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeSignedLong(writeBuffer, 64), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.REAL32)) {
            FieldWriterFactory.writeSimpleField("value", Float.valueOf(_value.getFloat()), DataWriterFactory.writeFloat(writeBuffer, 32), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        } else if (EvaluationHelper.equals((Object)dataType, (Object)GenericCANDataType.REAL64)) {
            FieldWriterFactory.writeSimpleField("value", _value.getDouble(), DataWriterFactory.writeDouble(writeBuffer, 64), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
        }
    }
}

