/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.knxnetip.readwrite.ApduDataExt;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class ApduDataExtAuthorizeRequest
extends ApduDataExt
implements Message {
    protected final short level;
    protected final byte[] data;

    @Override
    public Byte getExtApciType() {
        return (byte)17;
    }

    public ApduDataExtAuthorizeRequest(short level, byte[] data) {
        this.level = level;
        this.data = data;
    }

    public short getLevel() {
        return this.level;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    protected void serializeApduDataExtChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ApduDataExtAuthorizeRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("level", this.level, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField("data", this.data, DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        writeBuffer.popContext("ApduDataExtAuthorizeRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ApduDataExtAuthorizeRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        return lengthInBits;
    }

    public static ApduDataExt.ApduDataExtBuilder staticParseApduDataExtBuilder(ReadBuffer readBuffer, Short length) throws ParseException {
        readBuffer.pullContext("ApduDataExtAuthorizeRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        short level = FieldReaderFactory.readSimpleField("level", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(4L), new WithReaderArgs[0]);
        readBuffer.closeContext("ApduDataExtAuthorizeRequest", new WithReaderArgs[0]);
        return new ApduDataExtAuthorizeRequestBuilderImpl(level, data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApduDataExtAuthorizeRequest)) {
            return false;
        }
        ApduDataExtAuthorizeRequest that = (ApduDataExtAuthorizeRequest)o;
        return this.getLevel() == that.getLevel() && this.getData() == that.getData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getLevel(), this.getData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ApduDataExtAuthorizeRequestBuilderImpl
    implements ApduDataExt.ApduDataExtBuilder {
        private final short level;
        private final byte[] data;

        public ApduDataExtAuthorizeRequestBuilderImpl(short level, byte[] data) {
            this.level = level;
            this.data = data;
        }

        @Override
        public ApduDataExtAuthorizeRequest build() {
            ApduDataExtAuthorizeRequest apduDataExtAuthorizeRequest = new ApduDataExtAuthorizeRequest(this.level, this.data);
            return apduDataExtAuthorizeRequest;
        }
    }
}

