/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.knxnetip.readwrite.ApduData;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class ApduDataGroupValueWrite
extends ApduData
implements Message {
    protected final byte dataFirstByte;
    protected final byte[] data;

    @Override
    public Byte getApciType() {
        return (byte)2;
    }

    public ApduDataGroupValueWrite(byte dataFirstByte, byte[] data) {
        this.dataFirstByte = dataFirstByte;
        this.data = data;
    }

    public byte getDataFirstByte() {
        return this.dataFirstByte;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    protected void serializeApduDataChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ApduDataGroupValueWrite", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("dataFirstByte", this.dataFirstByte, DataWriterFactory.writeSignedByte(writeBuffer, 6), new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField("data", this.data, DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
        writeBuffer.popContext("ApduDataGroupValueWrite", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ApduDataGroupValueWrite _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 6;
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        return lengthInBits;
    }

    public static ApduData.ApduDataBuilder staticParseApduDataBuilder(ReadBuffer readBuffer, Short dataLength) throws ParseException {
        readBuffer.pullContext("ApduDataGroupValueWrite", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        byte dataFirstByte = FieldReaderFactory.readSimpleField("dataFirstByte", DataReaderFactory.readSignedByte(readBuffer, 6), new WithReaderArgs[0]);
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(dataLength < 1 ? 0 : dataLength - 1), new WithReaderArgs[0]);
        readBuffer.closeContext("ApduDataGroupValueWrite", new WithReaderArgs[0]);
        return new ApduDataGroupValueWriteBuilderImpl(dataFirstByte, data);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApduDataGroupValueWrite)) {
            return false;
        }
        ApduDataGroupValueWrite that = (ApduDataGroupValueWrite)o;
        return this.getDataFirstByte() == that.getDataFirstByte() && this.getData() == that.getData() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDataFirstByte(), this.getData());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ApduDataGroupValueWriteBuilderImpl
    implements ApduData.ApduDataBuilder {
        private final byte dataFirstByte;
        private final byte[] data;

        public ApduDataGroupValueWriteBuilderImpl(byte dataFirstByte, byte[] data) {
            this.dataFirstByte = dataFirstByte;
            this.data = data;
        }

        @Override
        public ApduDataGroupValueWrite build() {
            ApduDataGroupValueWrite apduDataGroupValueWrite = new ApduDataGroupValueWrite(this.dataFirstByte, this.data);
            return apduDataGroupValueWrite;
        }
    }
}

