/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class KnxAddress
implements Message {
    protected final byte mainGroup;
    protected final byte middleGroup;
    protected final short subGroup;

    public KnxAddress(byte mainGroup, byte middleGroup, short subGroup) {
        this.mainGroup = mainGroup;
        this.middleGroup = middleGroup;
        this.subGroup = subGroup;
    }

    public byte getMainGroup() {
        return this.mainGroup;
    }

    public byte getMiddleGroup() {
        return this.middleGroup;
    }

    public short getSubGroup() {
        return this.subGroup;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("KnxAddress", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("mainGroup", this.mainGroup, DataWriterFactory.writeUnsignedByte(writeBuffer, 4), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("middleGroup", this.middleGroup, DataWriterFactory.writeUnsignedByte(writeBuffer, 4), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("subGroup", this.subGroup, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        writeBuffer.popContext("KnxAddress", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        KnxAddress _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 4;
        lengthInBits += 4;
        return lengthInBits += 8;
    }

    public static KnxAddress staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return KnxAddress.staticParse(readBuffer);
    }

    public static KnxAddress staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("KnxAddress", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        byte mainGroup = FieldReaderFactory.readSimpleField("mainGroup", DataReaderFactory.readUnsignedByte(readBuffer, 4), new WithReaderArgs[0]);
        byte middleGroup = FieldReaderFactory.readSimpleField("middleGroup", DataReaderFactory.readUnsignedByte(readBuffer, 4), new WithReaderArgs[0]);
        short subGroup = FieldReaderFactory.readSimpleField("subGroup", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
        readBuffer.closeContext("KnxAddress", new WithReaderArgs[0]);
        KnxAddress _knxAddress = new KnxAddress(mainGroup, middleGroup, subGroup);
        return _knxAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KnxAddress)) {
            return false;
        }
        KnxAddress that = (KnxAddress)o;
        return this.getMainGroup() == that.getMainGroup() && this.getMiddleGroup() == that.getMiddleGroup() && this.getSubGroup() == that.getSubGroup();
    }

    public int hashCode() {
        return Objects.hash(this.getMainGroup(), this.getMiddleGroup(), this.getSubGroup());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

