/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.knxnetip.readwrite.ConnectionRequest;
import org.apache.plc4x.java.knxnetip.readwrite.ConnectionResponse;
import org.apache.plc4x.java.knxnetip.readwrite.ConnectionStateRequest;
import org.apache.plc4x.java.knxnetip.readwrite.ConnectionStateResponse;
import org.apache.plc4x.java.knxnetip.readwrite.DescriptionRequest;
import org.apache.plc4x.java.knxnetip.readwrite.DescriptionResponse;
import org.apache.plc4x.java.knxnetip.readwrite.DeviceConfigurationAck;
import org.apache.plc4x.java.knxnetip.readwrite.DeviceConfigurationRequest;
import org.apache.plc4x.java.knxnetip.readwrite.DisconnectRequest;
import org.apache.plc4x.java.knxnetip.readwrite.DisconnectResponse;
import org.apache.plc4x.java.knxnetip.readwrite.RoutingIndication;
import org.apache.plc4x.java.knxnetip.readwrite.SearchRequest;
import org.apache.plc4x.java.knxnetip.readwrite.SearchResponse;
import org.apache.plc4x.java.knxnetip.readwrite.TunnelingRequest;
import org.apache.plc4x.java.knxnetip.readwrite.TunnelingResponse;
import org.apache.plc4x.java.knxnetip.readwrite.UnknownMessage;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public abstract class KnxNetIpMessage
implements Message {
    public static final Short PROTOCOLVERSION = 16;

    public abstract Integer getMsgType();

    public short getProtocolVersion() {
        return PROTOCOLVERSION;
    }

    protected abstract void serializeKnxNetIpMessageChild(WriteBuffer var1) throws SerializationException;

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("KnxNetIpMessage", new WithWriterArgs[0]);
        short headerLength = 6;
        FieldWriterFactory.writeImplicitField("headerLength", headerLength, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        FieldWriterFactory.writeConstField("protocolVersion", PROTOCOLVERSION, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        FieldWriterFactory.writeDiscriminatorField("msgType", this.getMsgType(), DataWriterFactory.writeUnsignedInt(writeBuffer, 16), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        int totalLength = this.getLengthInBytes();
        FieldWriterFactory.writeImplicitField("totalLength", totalLength, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        this.serializeKnxNetIpMessageChild(writeBuffer);
        writeBuffer.popContext("KnxNetIpMessage", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        KnxNetIpMessage _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += 8;
        lengthInBits += 16;
        return lengthInBits += 16;
    }

    public static KnxNetIpMessage staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return KnxNetIpMessage.staticParse(readBuffer);
    }

    public static KnxNetIpMessage staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("KnxNetIpMessage", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        short headerLength = FieldReaderFactory.readImplicitField("headerLength", DataReaderFactory.readUnsignedShort(readBuffer, 8), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        short protocolVersion = FieldReaderFactory.readConstField("protocolVersion", DataReaderFactory.readUnsignedShort(readBuffer, 8), PROTOCOLVERSION, WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        int msgType = FieldReaderFactory.readDiscriminatorField("msgType", DataReaderFactory.readUnsignedInt(readBuffer, 16), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        int totalLength = FieldReaderFactory.readImplicitField("totalLength", DataReaderFactory.readUnsignedInt(readBuffer, 16), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));
        KnxNetIpMessageBuilder builder = null;
        if (EvaluationHelper.equals(msgType, 513)) {
            builder = SearchRequest.staticParseKnxNetIpMessageBuilder(readBuffer);
        } else if (EvaluationHelper.equals(msgType, 514)) {
            builder = SearchResponse.staticParseKnxNetIpMessageBuilder(readBuffer);
        } else if (EvaluationHelper.equals(msgType, 515)) {
            builder = DescriptionRequest.staticParseKnxNetIpMessageBuilder(readBuffer);
        } else if (EvaluationHelper.equals(msgType, 516)) {
            builder = DescriptionResponse.staticParseKnxNetIpMessageBuilder(readBuffer);
        } else if (EvaluationHelper.equals(msgType, 517)) {
            builder = ConnectionRequest.staticParseKnxNetIpMessageBuilder(readBuffer);
        } else if (EvaluationHelper.equals(msgType, 518)) {
            builder = ConnectionResponse.staticParseKnxNetIpMessageBuilder(readBuffer);
        } else if (EvaluationHelper.equals(msgType, 519)) {
            builder = ConnectionStateRequest.staticParseKnxNetIpMessageBuilder(readBuffer);
        } else if (EvaluationHelper.equals(msgType, 520)) {
            builder = ConnectionStateResponse.staticParseKnxNetIpMessageBuilder(readBuffer);
        } else if (EvaluationHelper.equals(msgType, 521)) {
            builder = DisconnectRequest.staticParseKnxNetIpMessageBuilder(readBuffer);
        } else if (EvaluationHelper.equals(msgType, 522)) {
            builder = DisconnectResponse.staticParseKnxNetIpMessageBuilder(readBuffer);
        } else if (EvaluationHelper.equals(msgType, 523)) {
            builder = UnknownMessage.staticParseKnxNetIpMessageBuilder(readBuffer, totalLength);
        } else if (EvaluationHelper.equals(msgType, 784)) {
            builder = DeviceConfigurationRequest.staticParseKnxNetIpMessageBuilder(readBuffer, totalLength);
        } else if (EvaluationHelper.equals(msgType, 785)) {
            builder = DeviceConfigurationAck.staticParseKnxNetIpMessageBuilder(readBuffer);
        } else if (EvaluationHelper.equals(msgType, 1056)) {
            builder = TunnelingRequest.staticParseKnxNetIpMessageBuilder(readBuffer, totalLength);
        } else if (EvaluationHelper.equals(msgType, 1057)) {
            builder = TunnelingResponse.staticParseKnxNetIpMessageBuilder(readBuffer);
        } else if (EvaluationHelper.equals(msgType, 1328)) {
            builder = RoutingIndication.staticParseKnxNetIpMessageBuilder(readBuffer);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [msgType=" + msgType + "]");
        }
        readBuffer.closeContext("KnxNetIpMessage", new WithReaderArgs[0]);
        KnxNetIpMessage _knxNetIpMessage = builder.build();
        return _knxNetIpMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KnxNetIpMessage)) {
            return false;
        }
        KnxNetIpMessage that = (KnxNetIpMessage)o;
        return true;
    }

    public int hashCode() {
        return Objects.hash(new Object[0]);
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface KnxNetIpMessageBuilder {
        public KnxNetIpMessage build();
    }
}

