/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.HashMap;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.knxnetip.readwrite.KnxPropertyDataType;
import org.apache.plc4x.java.spi.codegen.WithOption;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcBYTE;
import org.apache.plc4x.java.spi.values.PlcDINT;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.apache.plc4x.java.spi.values.PlcLREAL;
import org.apache.plc4x.java.spi.values.PlcREAL;
import org.apache.plc4x.java.spi.values.PlcRawByteArray;
import org.apache.plc4x.java.spi.values.PlcSINT;
import org.apache.plc4x.java.spi.values.PlcStruct;
import org.apache.plc4x.java.spi.values.PlcUDINT;
import org.apache.plc4x.java.spi.values.PlcUINT;
import org.apache.plc4x.java.spi.values.PlcUSINT;
import org.apache.plc4x.java.spi.values.PlcWORD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnxProperty {
    private static final Logger LOGGER = LoggerFactory.getLogger(KnxProperty.class);

    public static PlcValue staticParse(ReadBuffer readBuffer, KnxPropertyDataType propertyType, Short dataLengthInBytes) throws ParseException {
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_CONTROL)) {
            Byte reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 7), (byte)0, new WithReaderArgs[0]);
            boolean value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_CHAR)) {
            byte value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedByte(readBuffer, 8), new WithReaderArgs[0]);
            return new PlcSINT(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_UNSIGNED_CHAR)) {
            short value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_INT)) {
            short value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedShort(readBuffer, 16), new WithReaderArgs[0]);
            return new PlcINT(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_UNSIGNED_INT) && EvaluationHelper.equals(dataLengthInBytes, (short)4)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_UNSIGNED_INT)) {
            int value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
            return new PlcUINT(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_KNX_FLOAT)) {
            float value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readFloat(readBuffer, 16), WithOption.WithEncoding("KNXFloat")).floatValue();
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_DATE)) {
            Byte reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 3), (byte)0, new WithReaderArgs[0]);
            byte dayOfMonth = FieldReaderFactory.readSimpleField("dayOfMonth", DataReaderFactory.readUnsignedByte(readBuffer, 5), new WithReaderArgs[0]);
            Byte reservedField1 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 4), (byte)0, new WithReaderArgs[0]);
            byte month = FieldReaderFactory.readSimpleField("month", DataReaderFactory.readUnsignedByte(readBuffer, 4), new WithReaderArgs[0]);
            Byte reservedField2 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 1), (byte)0, new WithReaderArgs[0]);
            byte year = FieldReaderFactory.readSimpleField("year", DataReaderFactory.readUnsignedByte(readBuffer, 7), new WithReaderArgs[0]);
            HashMap<String, PlcValue> _map = new HashMap<String, PlcValue>();
            _map.put("dayOfMonth", new PlcUSINT((short)dayOfMonth));
            _map.put("month", new PlcUSINT((short)month));
            _map.put("year", new PlcUSINT((short)year));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_TIME)) {
            byte day = FieldReaderFactory.readSimpleField("day", DataReaderFactory.readUnsignedByte(readBuffer, 3), new WithReaderArgs[0]);
            byte hour = FieldReaderFactory.readSimpleField("hour", DataReaderFactory.readUnsignedByte(readBuffer, 5), new WithReaderArgs[0]);
            Byte reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 2), (byte)0, new WithReaderArgs[0]);
            byte minutes = FieldReaderFactory.readSimpleField("minutes", DataReaderFactory.readUnsignedByte(readBuffer, 6), new WithReaderArgs[0]);
            Byte reservedField1 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 2), (byte)0, new WithReaderArgs[0]);
            byte seconds = FieldReaderFactory.readSimpleField("seconds", DataReaderFactory.readUnsignedByte(readBuffer, 6), new WithReaderArgs[0]);
            HashMap<String, PlcValue> _map = new HashMap<String, PlcValue>();
            _map.put("day", new PlcUSINT((short)day));
            _map.put("hour", new PlcUSINT((short)hour));
            _map.put("minutes", new PlcUSINT((short)minutes));
            _map.put("seconds", new PlcUSINT((short)seconds));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_LONG)) {
            int value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
            return new PlcDINT(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_UNSIGNED_LONG)) {
            long value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
            return new PlcUDINT(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_FLOAT)) {
            float value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readFloat(readBuffer, 32), new WithReaderArgs[0]).floatValue();
            return new PlcREAL(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_DOUBLE)) {
            double value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readDouble(readBuffer, 64), new WithReaderArgs[0]);
            return new PlcLREAL(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_CHAR_BLOCK)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(10L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_POLL_GROUP_SETTINGS)) {
            byte[] groupAddress = readBuffer.readByteArray("groupAddress", Math.toIntExact(2L), new WithReaderArgs[0]);
            boolean disable = FieldReaderFactory.readSimpleField("disable", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            Byte reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 3), (byte)0, new WithReaderArgs[0]);
            byte pollingSoftNr = FieldReaderFactory.readSimpleField("pollingSoftNr", DataReaderFactory.readUnsignedByte(readBuffer, 4), new WithReaderArgs[0]);
            HashMap<String, PlcValue> _map = new HashMap<String, PlcValue>();
            _map.put("groupAddress", new PlcRawByteArray(groupAddress));
            _map.put("disable", new PlcBOOL(disable));
            _map.put("pollingSoftNr", new PlcUSINT((short)pollingSoftNr));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_SHORT_CHAR_BLOCK)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(5L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_DATE_TIME)) {
            short year = FieldReaderFactory.readSimpleField("year", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            Byte reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 4), (byte)0, new WithReaderArgs[0]);
            byte month = FieldReaderFactory.readSimpleField("month", DataReaderFactory.readUnsignedByte(readBuffer, 4), new WithReaderArgs[0]);
            Byte reservedField1 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 3), (byte)0, new WithReaderArgs[0]);
            byte dayOfMonth = FieldReaderFactory.readSimpleField("dayOfMonth", DataReaderFactory.readUnsignedByte(readBuffer, 5), new WithReaderArgs[0]);
            byte dayOfWeek = FieldReaderFactory.readSimpleField("dayOfWeek", DataReaderFactory.readUnsignedByte(readBuffer, 3), new WithReaderArgs[0]);
            byte hour = FieldReaderFactory.readSimpleField("hour", DataReaderFactory.readUnsignedByte(readBuffer, 5), new WithReaderArgs[0]);
            Byte reservedField2 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 2), (byte)0, new WithReaderArgs[0]);
            byte minutes = FieldReaderFactory.readSimpleField("minutes", DataReaderFactory.readUnsignedByte(readBuffer, 6), new WithReaderArgs[0]);
            Byte reservedField3 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 2), (byte)0, new WithReaderArgs[0]);
            byte seconds = FieldReaderFactory.readSimpleField("seconds", DataReaderFactory.readUnsignedByte(readBuffer, 6), new WithReaderArgs[0]);
            boolean fault = FieldReaderFactory.readSimpleField("fault", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            boolean workingDay = FieldReaderFactory.readSimpleField("workingDay", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            boolean noWd = FieldReaderFactory.readSimpleField("noWd", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            boolean noYear = FieldReaderFactory.readSimpleField("noYear", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            boolean noDate = FieldReaderFactory.readSimpleField("noDate", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            boolean noDayOfWeek = FieldReaderFactory.readSimpleField("noDayOfWeek", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            boolean noTime = FieldReaderFactory.readSimpleField("noTime", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            boolean standardSummerTime = FieldReaderFactory.readSimpleField("standardSummerTime", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            boolean qualityOfClock = FieldReaderFactory.readSimpleField("qualityOfClock", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            Byte reservedField4 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 7), (byte)0, new WithReaderArgs[0]);
            HashMap<String, PlcValue> _map = new HashMap<String, PlcValue>();
            _map.put("year", new PlcUSINT(year));
            _map.put("month", new PlcUSINT((short)month));
            _map.put("dayOfMonth", new PlcUSINT((short)dayOfMonth));
            _map.put("dayOfWeek", new PlcUSINT((short)dayOfWeek));
            _map.put("hour", new PlcUSINT((short)hour));
            _map.put("minutes", new PlcUSINT((short)minutes));
            _map.put("seconds", new PlcUSINT((short)seconds));
            _map.put("fault", new PlcBOOL(fault));
            _map.put("workingDay", new PlcBOOL(workingDay));
            _map.put("noWd", new PlcBOOL(noWd));
            _map.put("noYear", new PlcBOOL(noYear));
            _map.put("noDate", new PlcBOOL(noDate));
            _map.put("noDayOfWeek", new PlcBOOL(noDayOfWeek));
            _map.put("noTime", new PlcBOOL(noTime));
            _map.put("standardSummerTime", new PlcBOOL(standardSummerTime));
            _map.put("qualityOfClock", new PlcBOOL(qualityOfClock));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_01)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(1L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_02)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(2L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_03)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(3L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_04)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(4L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_05)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(5L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_06)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(6L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_07)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(7L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_08)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(8L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_09)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(9L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_10)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(10L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_11)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(11L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_12)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(12L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_13)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(13L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_14)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(14L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_15)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(15L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_16)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(16L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_17)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(17L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_18)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(18L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_19)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(19L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_20)) {
            byte[] value = readBuffer.readByteArray("value", Math.toIntExact(20L), new WithReaderArgs[0]);
            return new PlcRawByteArray(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_VERSION)) {
            byte magicNumber = FieldReaderFactory.readSimpleField("magicNumber", DataReaderFactory.readUnsignedByte(readBuffer, 5), new WithReaderArgs[0]);
            byte versionNumber = FieldReaderFactory.readSimpleField("versionNumber", DataReaderFactory.readUnsignedByte(readBuffer, 5), new WithReaderArgs[0]);
            byte revisionNumber = FieldReaderFactory.readSimpleField("revisionNumber", DataReaderFactory.readUnsignedByte(readBuffer, 6), new WithReaderArgs[0]);
            HashMap<String, PlcValue> _map = new HashMap<String, PlcValue>();
            _map.put("magicNumber", new PlcUSINT((short)magicNumber));
            _map.put("versionNumber", new PlcUSINT((short)versionNumber));
            _map.put("revisionNumber", new PlcUSINT((short)revisionNumber));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_ALARM_INFO)) {
            short logNumber = FieldReaderFactory.readSimpleField("logNumber", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            short alarmPriority = FieldReaderFactory.readSimpleField("alarmPriority", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            short applicationArea = FieldReaderFactory.readSimpleField("applicationArea", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            short errorClass = FieldReaderFactory.readSimpleField("errorClass", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            Byte reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 4), (byte)0, new WithReaderArgs[0]);
            boolean errorcodeSup = FieldReaderFactory.readSimpleField("errorcodeSup", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            boolean alarmtextSup = FieldReaderFactory.readSimpleField("alarmtextSup", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            boolean timestampSup = FieldReaderFactory.readSimpleField("timestampSup", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            boolean ackSup = FieldReaderFactory.readSimpleField("ackSup", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            Byte reservedField1 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 5), (byte)0, new WithReaderArgs[0]);
            boolean locked = FieldReaderFactory.readSimpleField("locked", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            boolean alarmunack = FieldReaderFactory.readSimpleField("alarmunack", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            boolean inalarm = FieldReaderFactory.readSimpleField("inalarm", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            HashMap<String, PlcValue> _map = new HashMap<String, PlcValue>();
            _map.put("logNumber", new PlcUSINT(logNumber));
            _map.put("alarmPriority", new PlcUSINT(alarmPriority));
            _map.put("applicationArea", new PlcUSINT(applicationArea));
            _map.put("errorClass", new PlcUSINT(errorClass));
            _map.put("errorcodeSup", new PlcBOOL(errorcodeSup));
            _map.put("alarmtextSup", new PlcBOOL(alarmtextSup));
            _map.put("timestampSup", new PlcBOOL(timestampSup));
            _map.put("ackSup", new PlcBOOL(ackSup));
            _map.put("locked", new PlcBOOL(locked));
            _map.put("alarmunack", new PlcBOOL(alarmunack));
            _map.put("inalarm", new PlcBOOL(inalarm));
            return new PlcStruct(_map);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_BINARY_INFORMATION)) {
            Byte reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 7), (byte)0, new WithReaderArgs[0]);
            boolean value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
            return new PlcBOOL(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_BITSET8)) {
            short value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            return new PlcBYTE(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_BITSET16)) {
            int value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
            return new PlcWORD(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_ENUM8)) {
            short value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_SCALING)) {
            short value = FieldReaderFactory.readSimpleField("value", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
            return new PlcUSINT(value);
        }
        byte[] value = readBuffer.readByteArray("value", Math.toIntExact(dataLengthInBytes.shortValue()), new WithReaderArgs[0]);
        return new PlcRawByteArray(value);
    }

    public static int getLengthInBytes(PlcValue _value, KnxPropertyDataType propertyType, Short dataLengthInBytes) {
        return (int)Math.ceil((double)KnxProperty.getLengthInBits(_value, propertyType, dataLengthInBytes) / 8.0);
    }

    public static int getLengthInBits(PlcValue _value, KnxPropertyDataType propertyType, Short dataLengthInBytes) {
        int lengthInBits = 0;
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_CONTROL)) {
            lengthInBits += 7;
            ++lengthInBits;
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_CHAR)) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_UNSIGNED_CHAR)) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_INT)) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_UNSIGNED_INT) && EvaluationHelper.equals(dataLengthInBytes, (short)4)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_UNSIGNED_INT)) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_KNX_FLOAT)) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_DATE)) {
            lengthInBits += 3;
            lengthInBits += 5;
            lengthInBits += 4;
            lengthInBits += 4;
            ++lengthInBits;
            lengthInBits += 7;
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_TIME)) {
            lengthInBits += 3;
            lengthInBits += 5;
            lengthInBits += 2;
            lengthInBits += 6;
            lengthInBits += 2;
            lengthInBits += 6;
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_LONG)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_UNSIGNED_LONG)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_FLOAT)) {
            lengthInBits += 32;
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_DOUBLE)) {
            lengthInBits += 64;
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_CHAR_BLOCK)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_POLL_GROUP_SETTINGS)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
            ++lengthInBits;
            lengthInBits += 3;
            lengthInBits += 4;
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_SHORT_CHAR_BLOCK)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_DATE_TIME)) {
            lengthInBits += 8;
            lengthInBits += 4;
            lengthInBits += 4;
            lengthInBits += 3;
            lengthInBits += 5;
            lengthInBits += 3;
            lengthInBits += 5;
            lengthInBits += 2;
            lengthInBits += 6;
            lengthInBits += 2;
            lengthInBits += 6;
            ++lengthInBits;
            ++lengthInBits;
            ++lengthInBits;
            ++lengthInBits;
            ++lengthInBits;
            ++lengthInBits;
            ++lengthInBits;
            ++lengthInBits;
            ++lengthInBits;
            lengthInBits += 7;
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_01)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_02)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_03)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_04)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_05)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_06)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_07)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_08)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_09)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_10)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_11)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_12)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_13)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_14)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_15)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_16)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_17)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_18)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_19)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_20)) {
            if (_value != null) {
                lengthInBits += 8 * _value.getRaw().length;
            }
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_VERSION)) {
            lengthInBits += 5;
            lengthInBits += 5;
            lengthInBits += 6;
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_ALARM_INFO)) {
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 8;
            lengthInBits += 4;
            ++lengthInBits;
            ++lengthInBits;
            ++lengthInBits;
            ++lengthInBits;
            lengthInBits += 5;
            ++lengthInBits;
            ++lengthInBits;
            ++lengthInBits;
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_BINARY_INFORMATION)) {
            lengthInBits += 7;
            ++lengthInBits;
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_BITSET8)) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_BITSET16)) {
            lengthInBits += 16;
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_ENUM8)) {
            lengthInBits += 8;
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_SCALING)) {
            lengthInBits += 8;
        } else if (_value != null) {
            lengthInBits += 8 * _value.getRaw().length;
        }
        return lengthInBits;
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, KnxPropertyDataType propertyType, Short dataLengthInBytes) throws SerializationException {
        KnxProperty.staticSerialize(writeBuffer, _value, propertyType, dataLengthInBytes, ByteOrder.BIG_ENDIAN);
    }

    public static void staticSerialize(WriteBuffer writeBuffer, PlcValue _value, KnxPropertyDataType propertyType, Short dataLengthInBytes, ByteOrder byteOrder) throws SerializationException {
        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_CONTROL)) {
            FieldWriterFactory.writeReservedField("reserved", (byte)0, DataWriterFactory.writeUnsignedByte(writeBuffer, 7), new WithWriterArgs[0]);
            FieldWriterFactory.writeSimpleField("value", _value.getBoolean(), DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_CHAR)) {
            FieldWriterFactory.writeSimpleField("value", _value.getByte(), DataWriterFactory.writeSignedByte(writeBuffer, 8), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_UNSIGNED_CHAR)) {
            FieldWriterFactory.writeSimpleField("value", _value.getShort(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_INT)) {
            FieldWriterFactory.writeSimpleField("value", _value.getShort(), DataWriterFactory.writeSignedShort(writeBuffer, 16), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_UNSIGNED_INT) && EvaluationHelper.equals(dataLengthInBytes, (short)4)) {
            FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_UNSIGNED_INT)) {
            FieldWriterFactory.writeSimpleField("value", _value.getInteger(), DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_KNX_FLOAT)) {
            FieldWriterFactory.writeSimpleField("value", Float.valueOf(_value.getFloat()), DataWriterFactory.writeFloat(writeBuffer, 16), WithOption.WithEncoding("KNXFloat"));
        } else if (!EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_DATE) && !EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_TIME)) {
            if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_LONG)) {
                FieldWriterFactory.writeSimpleField("value", _value.getInteger(), DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
            } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_UNSIGNED_LONG)) {
                FieldWriterFactory.writeSimpleField("value", _value.getLong(), DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
            } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_FLOAT)) {
                FieldWriterFactory.writeSimpleField("value", Float.valueOf(_value.getFloat()), DataWriterFactory.writeFloat(writeBuffer, 32), new WithWriterArgs[0]);
            } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_DOUBLE)) {
                FieldWriterFactory.writeSimpleField("value", _value.getDouble(), DataWriterFactory.writeDouble(writeBuffer, 64), new WithWriterArgs[0]);
            } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_CHAR_BLOCK)) {
                FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
            } else if (!EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_POLL_GROUP_SETTINGS)) {
                if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_SHORT_CHAR_BLOCK)) {
                    FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                } else if (!EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_DATE_TIME)) {
                    if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_01)) {
                        FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                    } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_02)) {
                        FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                    } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_03)) {
                        FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                    } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_04)) {
                        FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                    } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_05)) {
                        FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                    } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_06)) {
                        FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                    } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_07)) {
                        FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                    } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_08)) {
                        FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                    } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_09)) {
                        FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                    } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_10)) {
                        FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                    } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_11)) {
                        FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                    } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_12)) {
                        FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                    } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_13)) {
                        FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                    } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_14)) {
                        FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                    } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_15)) {
                        FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                    } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_16)) {
                        FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                    } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_17)) {
                        FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                    } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_18)) {
                        FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                    } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_19)) {
                        FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                    } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_GENERIC_20)) {
                        FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                    } else if (!EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_VERSION) && !EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_ALARM_INFO)) {
                        if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_BINARY_INFORMATION)) {
                            FieldWriterFactory.writeReservedField("reserved", (byte)0, DataWriterFactory.writeUnsignedByte(writeBuffer, 7), new WithWriterArgs[0]);
                            FieldWriterFactory.writeSimpleField("value", _value.getBoolean(), DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
                        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_BITSET8)) {
                            FieldWriterFactory.writeSimpleField("value", _value.getShort(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
                        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_BITSET16)) {
                            FieldWriterFactory.writeSimpleField("value", _value.getInteger(), DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
                        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_ENUM8)) {
                            FieldWriterFactory.writeSimpleField("value", _value.getShort(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
                        } else if (EvaluationHelper.equals((Object)propertyType, (Object)KnxPropertyDataType.PDT_SCALING)) {
                            FieldWriterFactory.writeSimpleField("value", _value.getShort(), DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
                        } else {
                            FieldWriterFactory.writeByteArrayField("value", _value.getRaw(), DataWriterFactory.writeByteArray(writeBuffer, 8), new WithWriterArgs[0]);
                        }
                    }
                }
            }
        }
    }
}

