/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.knxnetip.tag;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcInvalidTagException;
import org.apache.plc4x.java.api.model.ArrayInfo;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.knxnetip.ets.model.GroupAddress;

public class KnxNetIpTag
implements PlcTag {
    private static final String WILDCARD = "*";
    private static final Pattern KNX_GROUP_ADDRESS_1_LEVEL = Pattern.compile("^(?<mainGroup>(\\d{1,5}|\\*))");
    private static final Pattern KNX_GROUP_ADDRESS_2_LEVEL = Pattern.compile("^(?<mainGroup>(\\d{1,2}|\\*))/(?<subGroup>(\\d{1,4}|\\*))");
    private static final Pattern KNX_GROUP_ADDRESS_3_LEVEL = Pattern.compile("^(?<mainGroup>(\\d{1,2}|\\*))/(?<middleGroup>(\\d|\\*))/(?<subGroup>(\\d{1,3}|\\*))");
    private final int levels;
    private final String mainGroup;
    private final String middleGroup;
    private final String subGroup;

    public static boolean matches(String tagString) {
        return KNX_GROUP_ADDRESS_3_LEVEL.matcher(tagString).matches() || KNX_GROUP_ADDRESS_2_LEVEL.matcher(tagString).matches() || KNX_GROUP_ADDRESS_1_LEVEL.matcher(tagString).matches();
    }

    public static KnxNetIpTag of(String tagString) {
        Matcher matcher = KNX_GROUP_ADDRESS_1_LEVEL.matcher(tagString);
        if (matcher.matches()) {
            return new KnxNetIpTag(1, matcher.group("mainGroup"), null, null);
        }
        matcher = KNX_GROUP_ADDRESS_2_LEVEL.matcher(tagString);
        if (matcher.matches()) {
            return new KnxNetIpTag(2, matcher.group("mainGroup"), null, matcher.group("subGroup"));
        }
        matcher = KNX_GROUP_ADDRESS_3_LEVEL.matcher(tagString);
        if (matcher.matches()) {
            return new KnxNetIpTag(3, matcher.group("mainGroup"), matcher.group("middleGroup"), matcher.group("subGroup"));
        }
        throw new PlcInvalidTagException("Unable to parse address: " + tagString);
    }

    public KnxNetIpTag(int levels, String mainGroup, String middleGroup, String subGroup) {
        this.levels = levels;
        this.mainGroup = mainGroup;
        this.middleGroup = middleGroup;
        this.subGroup = subGroup;
    }

    public int getLevels() {
        return this.levels;
    }

    public String getMainGroup() {
        return this.mainGroup;
    }

    public String getMiddleGroup() {
        return this.middleGroup;
    }

    public String getSubGroup() {
        return this.subGroup;
    }

    @Override
    public String getAddressString() {
        String address = this.mainGroup;
        if (this.middleGroup != null) {
            address = String.valueOf(address) + "/" + this.middleGroup;
        }
        if (this.subGroup != null) {
            address = String.valueOf(address) + "/" + this.subGroup;
        }
        return address;
    }

    @Override
    public PlcValueType getPlcValueType() {
        return PlcValueType.NULL;
    }

    @Override
    public List<ArrayInfo> getArrayInfo() {
        return PlcTag.super.getArrayInfo();
    }

    public boolean matchesGroupAddress(GroupAddress groupAddress) {
        KnxNetIpTag otherAddress = KnxNetIpTag.of(groupAddress.getGroupAddress());
        if (otherAddress.getLevels() != this.getLevels()) {
            return false;
        }
        if (this.getLevels() == 3 && !WILDCARD.equals(this.getMiddleGroup()) && !this.getMiddleGroup().equals(otherAddress.getMiddleGroup())) {
            return false;
        }
        if (this.getLevels() >= 2 && !WILDCARD.equals(this.getSubGroup()) && !this.getSubGroup().equals(otherAddress.getSubGroup())) {
            return false;
        }
        return WILDCARD.equals(this.getMainGroup()) || this.getMainGroup().equals(otherAddress.getMainGroup());
    }
}

