/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.ascii;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.plc4x.java.modbus.ascii.config.ModbusAsciiConfiguration;
import org.apache.plc4x.java.modbus.ascii.protocol.ModbusAsciiProtocolLogic;
import org.apache.plc4x.java.modbus.base.tag.ModbusTag;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagHandler;
import org.apache.plc4x.java.modbus.readwrite.DriverType;
import org.apache.plc4x.java.modbus.readwrite.ModbusAsciiADU;
import org.apache.plc4x.java.modbus.tcp.config.ModbusTcpTransportConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcTransportConfiguration;
import org.apache.plc4x.java.spi.connection.GeneratedDriverBase;
import org.apache.plc4x.java.spi.connection.ProtocolStackConfigurer;
import org.apache.plc4x.java.spi.connection.SingleProtocolStackConfigurer;
import org.apache.plc4x.java.spi.generation.MessageInput;
import org.apache.plc4x.java.spi.generation.MessageOutput;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.ReadBufferByteBased;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.optimizer.BaseOptimizer;
import org.apache.plc4x.java.spi.optimizer.SingleTagOptimizer;
import org.apache.plc4x.java.spi.values.PlcValueHandler;

public class ModbusAsciiDriver
extends GeneratedDriverBase<ModbusAsciiADU> {
    @Override
    public String getProtocolCode() {
        return "modbus-ascii";
    }

    @Override
    public String getProtocolName() {
        return "Modbus ASCII";
    }

    @Override
    protected Class<? extends PlcConnectionConfiguration> getConfigurationClass() {
        return ModbusAsciiConfiguration.class;
    }

    @Override
    protected Optional<Class<? extends PlcTransportConfiguration>> getTransportConfigurationClass(String transportCode) {
        switch (transportCode) {
            case "tcp": {
                return Optional.of(ModbusTcpTransportConfiguration.class);
            }
        }
        return Optional.empty();
    }

    @Override
    protected Optional<String> getDefaultTransportCode() {
        return Optional.of("serial");
    }

    @Override
    protected List<String> getSupportedTransportCodes() {
        return Arrays.asList("tcp", "serial");
    }

    @Override
    protected boolean awaitSetupComplete() {
        return false;
    }

    @Override
    protected boolean awaitDisconnectComplete() {
        return false;
    }

    @Override
    protected boolean canPing() {
        return true;
    }

    @Override
    protected boolean canRead() {
        return true;
    }

    @Override
    protected boolean canWrite() {
        return true;
    }

    @Override
    protected BaseOptimizer getOptimizer() {
        return new SingleTagOptimizer();
    }

    @Override
    protected ModbusTagHandler getTagHandler() {
        return new ModbusTagHandler();
    }

    @Override
    protected org.apache.plc4x.java.api.value.PlcValueHandler getValueHandler() {
        return new PlcValueHandler();
    }

    @Override
    protected ProtocolStackConfigurer<ModbusAsciiADU> getStackConfigurer() {
        return SingleProtocolStackConfigurer.builder(ModbusAsciiADU.class, new ModbusAsciiInput(), new ModbusAsciiOutput()).withProtocol(ModbusAsciiProtocolLogic.class).withPacketSizeEstimator(ByteLengthEstimator.class).withParserArgs(new Object[]{DriverType.MODBUS_ASCII, true}).build();
    }

    @Override
    public ModbusTag prepareTag(String tagAddress) {
        return ModbusTag.of(tagAddress);
    }

    public static class ByteLengthEstimator
    implements ToIntFunction<ByteBuf> {
        @Override
        public int applyAsInt(ByteBuf byteBuf) {
            if (byteBuf.readableBytes() >= 1) {
                return byteBuf.readableBytes();
            }
            return -1;
        }
    }

    public static class ModbusAsciiInput
    implements MessageInput<ModbusAsciiADU> {
        @Override
        public ModbusAsciiADU parse(ReadBuffer io, Object ... args) throws ParseException {
            short startChar = io.readShort(8, new WithReaderArgs[0]);
            if (startChar != 58) {
                throw new ParseException(String.format("Expected starting ':' character but got %c", startChar));
            }
            ReadBufferByteBased bufferByteBased = (ReadBufferByteBased)io;
            byte[] bytes = bufferByteBased.getBytes(bufferByteBased.getPos(), bufferByteBased.getTotalBytes() - 2);
            String inputString = new String(bytes, StandardCharsets.UTF_8);
            try {
                byte[] decodedBytes = Hex.decodeHex(inputString);
                ReadBufferByteBased readBuffer = new ReadBufferByteBased(decodedBytes);
                return (ModbusAsciiADU)ModbusAsciiADU.staticParse((ReadBuffer)readBuffer, DriverType.MODBUS_ASCII, true);
            }
            catch (DecoderException e) {
                throw new ParseException(String.format("Error parsing incoming message: %s", inputString), e);
            }
        }
    }

    public static class ModbusAsciiOutput
    implements MessageOutput<ModbusAsciiADU> {
        @Override
        public WriteBufferByteBased serialize(ModbusAsciiADU value, Object ... args) throws SerializationException {
            WriteBufferByteBased writeBufferByteBased = new WriteBufferByteBased(value.getLengthInBytes());
            value.serialize(writeBufferByteBased);
            byte[] decodedBytes = writeBufferByteBased.getBytes();
            String hexString = Hex.encodeHexString(decodedBytes).toUpperCase();
            WriteBufferByteBased encodedWriteBuffer = new WriteBufferByteBased(hexString.length() + 3);
            encodedWriteBuffer.writeShort(8, (short)58, new WithWriterArgs[0]);
            encodedWriteBuffer.writeByteArray(hexString.getBytes(StandardCharsets.UTF_8), new WithWriterArgs[0]);
            encodedWriteBuffer.writeShort(8, (short)13, new WithWriterArgs[0]);
            encodedWriteBuffer.writeShort(8, (short)10, new WithWriterArgs[0]);
            return encodedWriteBuffer;
        }
    }
}

