/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class ModbusPDUReadFileRecordRequestItem
implements Message {
    protected final short referenceType;
    protected final int fileNumber;
    protected final int recordNumber;
    protected final int recordLength;

    public ModbusPDUReadFileRecordRequestItem(short referenceType, int fileNumber, int recordNumber, int recordLength) {
        this.referenceType = referenceType;
        this.fileNumber = fileNumber;
        this.recordNumber = recordNumber;
        this.recordLength = recordLength;
    }

    public short getReferenceType() {
        return this.referenceType;
    }

    public int getFileNumber() {
        return this.fileNumber;
    }

    public int getRecordNumber() {
        return this.recordNumber;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ModbusPDUReadFileRecordRequestItem", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("referenceType", this.referenceType, DataWriterFactory.writeUnsignedShort(writeBuffer, 8), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("fileNumber", this.fileNumber, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("recordNumber", this.recordNumber, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("recordLength", this.recordLength, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        writeBuffer.popContext("ModbusPDUReadFileRecordRequestItem", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        ModbusPDUReadFileRecordRequestItem _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += 16;
        lengthInBits += 16;
        return lengthInBits += 16;
    }

    public static ModbusPDUReadFileRecordRequestItem staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return ModbusPDUReadFileRecordRequestItem.staticParse(readBuffer);
    }

    public static ModbusPDUReadFileRecordRequestItem staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("ModbusPDUReadFileRecordRequestItem", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        short referenceType = FieldReaderFactory.readSimpleField("referenceType", DataReaderFactory.readUnsignedShort(readBuffer, 8), new WithReaderArgs[0]);
        int fileNumber = FieldReaderFactory.readSimpleField("fileNumber", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        int recordNumber = FieldReaderFactory.readSimpleField("recordNumber", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        int recordLength = FieldReaderFactory.readSimpleField("recordLength", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        readBuffer.closeContext("ModbusPDUReadFileRecordRequestItem", new WithReaderArgs[0]);
        ModbusPDUReadFileRecordRequestItem _modbusPDUReadFileRecordRequestItem = new ModbusPDUReadFileRecordRequestItem(referenceType, fileNumber, recordNumber, recordLength);
        return _modbusPDUReadFileRecordRequestItem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusPDUReadFileRecordRequestItem)) {
            return false;
        }
        ModbusPDUReadFileRecordRequestItem that = (ModbusPDUReadFileRecordRequestItem)o;
        return this.getReferenceType() == that.getReferenceType() && this.getFileNumber() == that.getFileNumber() && this.getRecordNumber() == that.getRecordNumber() && this.getRecordLength() == that.getRecordLength();
    }

    public int hashCode() {
        return Objects.hash(this.getReferenceType(), this.getFileNumber(), this.getRecordNumber(), this.getRecordLength());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

