/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class ModbusPDUReadHoldingRegistersRequest
extends ModbusPDU
implements Message {
    protected final int startingAddress;
    protected final int quantity;

    @Override
    public Boolean getErrorFlag() {
        return false;
    }

    @Override
    public Byte getFunctionFlag() {
        return (byte)3;
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    public ModbusPDUReadHoldingRegistersRequest(int startingAddress, int quantity) {
        this.startingAddress = startingAddress;
        this.quantity = quantity;
    }

    public int getStartingAddress() {
        return this.startingAddress;
    }

    public int getQuantity() {
        return this.quantity;
    }

    @Override
    protected void serializeModbusPDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ModbusPDUReadHoldingRegistersRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("startingAddress", this.startingAddress, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("quantity", this.quantity, DataWriterFactory.writeUnsignedInt(writeBuffer, 16), new WithWriterArgs[0]);
        writeBuffer.popContext("ModbusPDUReadHoldingRegistersRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ModbusPDUReadHoldingRegistersRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 16;
        return lengthInBits += 16;
    }

    public static ModbusPDU.ModbusPDUBuilder staticParseModbusPDUBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("ModbusPDUReadHoldingRegistersRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int startingAddress = FieldReaderFactory.readSimpleField("startingAddress", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        int quantity = FieldReaderFactory.readSimpleField("quantity", DataReaderFactory.readUnsignedInt(readBuffer, 16), new WithReaderArgs[0]);
        readBuffer.closeContext("ModbusPDUReadHoldingRegistersRequest", new WithReaderArgs[0]);
        return new ModbusPDUReadHoldingRegistersRequestBuilderImpl(startingAddress, quantity);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModbusPDUReadHoldingRegistersRequest)) {
            return false;
        }
        ModbusPDUReadHoldingRegistersRequest that = (ModbusPDUReadHoldingRegistersRequest)o;
        return this.getStartingAddress() == that.getStartingAddress() && this.getQuantity() == that.getQuantity() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getStartingAddress(), this.getQuantity());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ModbusPDUReadHoldingRegistersRequestBuilderImpl
    implements ModbusPDU.ModbusPDUBuilder {
        private final int startingAddress;
        private final int quantity;

        public ModbusPDUReadHoldingRegistersRequestBuilderImpl(int startingAddress, int quantity) {
            this.startingAddress = startingAddress;
            this.quantity = quantity;
        }

        @Override
        public ModbusPDUReadHoldingRegistersRequest build() {
            ModbusPDUReadHoldingRegistersRequest modbusPDUReadHoldingRegistersRequest = new ModbusPDUReadHoldingRegistersRequest(this.startingAddress, this.quantity);
            return modbusPDUReadHoldingRegistersRequest;
        }
    }
}

