/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.context;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import javax.crypto.Cipher;
import org.apache.plc4x.java.opcua.context.BaseEncryptionHandler;
import org.apache.plc4x.java.opcua.context.Conversation;
import org.apache.plc4x.java.opcua.protocol.chunk.Chunk;
import org.apache.plc4x.java.opcua.security.SecurityPolicy;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;

public class AsymmetricEncryptionHandler
extends BaseEncryptionHandler {
    private final PrivateKey senderPrivateKey;

    public AsymmetricEncryptionHandler(Conversation conversation, SecurityPolicy securityPolicy, PrivateKey senderPrivateKey) {
        super(conversation, securityPolicy);
        this.senderPrivateKey = senderPrivateKey;
    }

    @Override
    protected void verify(WriteBufferByteBased buffer, Chunk chunk, int messageLength) throws Exception {
        int signatureStart = messageLength - chunk.getSignatureSize();
        byte[] message = buffer.getBytes(0, signatureStart);
        byte[] signatureData = buffer.getBytes(signatureStart, signatureStart + chunk.getSignatureSize());
        Signature signature = this.securityPolicy.getAsymmetricSignatureAlgorithm().getSignature();
        signature.initVerify(this.conversation.getRemoteCertificate().getPublicKey());
        signature.update(message);
        if (signature.verify(signatureData)) {
            throw new IllegalArgumentException("Invalid signature");
        }
    }

    @Override
    protected int decrypt(WriteBufferByteBased chunkBuffer, Chunk chunk, int messageLength) throws Exception {
        int bodyStart = 12 + chunk.getSecurityHeaderSize();
        int bodySize = messageLength - bodyStart;
        int blockCount = bodySize / chunk.getCipherTextBlockSize();
        assert (bodySize % chunk.getCipherTextBlockSize() == 0);
        byte[] encrypted = chunkBuffer.getBytes(bodyStart, bodyStart + bodySize);
        byte[] plainText = new byte[chunk.getCipherTextBlockSize() * blockCount];
        Cipher cipher = this.securityPolicy.getAsymmetricEncryptionAlgorithm().getCipher();
        cipher.init(2, this.senderPrivateKey);
        int bodyLength = 0;
        int block = 0;
        while (block < blockCount) {
            int pos = block * chunk.getCipherTextBlockSize();
            bodyLength += cipher.doFinal(encrypted, pos, chunk.getCipherTextBlockSize(), plainText, pos);
            ++block;
        }
        chunkBuffer.setPos(bodyStart);
        byte[] decrypted = new byte[bodyLength];
        System.arraycopy(plainText, 0, decrypted, 0, bodyLength);
        chunkBuffer.writeByteArray("payload", decrypted, new WithWriterArgs[0]);
        return bodyLength;
    }

    @Override
    protected void encrypt(WriteBufferByteBased buffer, int securityHeaderSize, int plainTextBlockSize, int cipherTextBlockSize, int blockCount) throws Exception {
        int bodyStart = 12 + securityHeaderSize;
        byte[] copy = buffer.getBytes(bodyStart, bodyStart + plainTextBlockSize * blockCount);
        byte[] encrypted = new byte[cipherTextBlockSize * blockCount];
        Cipher cipher = this.securityPolicy.getAsymmetricEncryptionAlgorithm().getCipher();
        cipher.init(1, this.conversation.getRemoteCertificate().getPublicKey());
        int block = 0;
        while (block < blockCount) {
            int pos = block * plainTextBlockSize;
            int target = block * cipherTextBlockSize;
            cipher.doFinal(copy, pos, plainTextBlockSize, encrypted, target);
            ++block;
        }
        buffer.setPos(bodyStart);
        buffer.writeByteArray("encrypted", encrypted, new WithWriterArgs[0]);
    }

    @Override
    public byte[] sign(byte[] contentsToSign) throws GeneralSecurityException {
        Signature signature = this.securityPolicy.getAsymmetricSignatureAlgorithm().getSignature();
        signature.initSign(this.senderPrivateKey);
        signature.update(contentsToSign);
        return signature.sign();
    }
}

