/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.context;

import io.vavr.control.Try;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Optional;

public class CertificateKeyPair {
    private final KeyPair keyPair;
    private final X509Certificate certificate;
    private final byte[] thumbprint;

    public CertificateKeyPair(KeyPair keyPair, X509Certificate certificate) throws GeneralSecurityException {
        this.keyPair = keyPair;
        this.certificate = certificate;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        this.thumbprint = messageDigest.digest(this.certificate.getEncoded());
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public PrivateKey getPrivateKey() {
        return this.keyPair.getPrivate();
    }

    public byte[] getThumbPrint() {
        return this.thumbprint;
    }

    public Optional<String> getApplicationUri() {
        Try<Collection> lists = Try.of(this.certificate::getSubjectAlternativeNames);
        return lists.toJavaStream().flatMap(Collection::stream).filter(l -> l.size() == 2).filter(name -> name.get(0).equals(6)).map(t -> (String)t.get(1)).findAny();
    }
}

