/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.context;

import io.vavr.control.Try;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Security;
import java.util.List;
import java.util.function.Supplier;
import javax.crypto.Cipher;
import org.apache.plc4x.java.opcua.context.AsymmetricEncryptionHandler;
import org.apache.plc4x.java.opcua.context.Conversation;
import org.apache.plc4x.java.opcua.context.SymmetricEncryptionHandler;
import org.apache.plc4x.java.opcua.protocol.chunk.Chunk;
import org.apache.plc4x.java.opcua.protocol.chunk.ChunkFactory;
import org.apache.plc4x.java.opcua.readwrite.MessagePDU;
import org.apache.plc4x.java.opcua.readwrite.OpcuaOpenRequest;
import org.apache.plc4x.java.opcua.readwrite.OpcuaOpenResponse;
import org.apache.plc4x.java.opcua.readwrite.OpcuaProtocolLimits;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.opcua.readwrite.SignatureData;
import org.apache.plc4x.java.opcua.security.SecurityPolicy;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionHandler {
    private final Logger logger = LoggerFactory.getLogger(EncryptionHandler.class);
    private final Conversation conversation;
    private final SymmetricEncryptionHandler symmetricEncryptionHandler;
    private final AsymmetricEncryptionHandler asymmetricEncryptionHandler;

    static {
        Security.addProvider(new BouncyCastleProvider());
    }

    public EncryptionHandler(Conversation conversation, PrivateKey senderPrivateKey) {
        this.conversation = conversation;
        this.symmetricEncryptionHandler = new SymmetricEncryptionHandler(conversation, conversation.getSecurityPolicy());
        this.asymmetricEncryptionHandler = new AsymmetricEncryptionHandler(conversation, conversation.getSecurityPolicy(), senderPrivateKey);
    }

    public List<MessagePDU> encodeMessage(MessagePDU message, Supplier<Integer> sequenceSupplier) {
        OpcuaProtocolLimits limits = this.conversation.getLimits();
        this.logger.debug("Encoding Message with Security policy {} and encoding limits {}", (Object)this.conversation.getSecurityPolicy(), (Object)limits);
        if (message instanceof OpcuaOpenRequest || message instanceof OpcuaOpenResponse) {
            Chunk chunk = new ChunkFactory().create(true, this.conversation.isSymmetricEncryptionEnabled(), this.conversation.isSymmetricSigningEnabled(), this.conversation.getSecurityPolicy(), limits, this.conversation.getLocalCertificate(), this.conversation.getRemoteCertificate());
            return this.asymmetricEncryptionHandler.encodeMessage(chunk, message, sequenceSupplier);
        }
        Chunk chunk = new ChunkFactory().create(false, this.conversation.isSymmetricEncryptionEnabled(), this.conversation.isSymmetricSigningEnabled(), this.conversation.getSecurityPolicy(), limits, this.conversation.getLocalCertificate(), this.conversation.getRemoteCertificate());
        return this.symmetricEncryptionHandler.encodeMessage(chunk, message, sequenceSupplier);
    }

    public MessagePDU decodeMessage(MessagePDU message) {
        OpcuaProtocolLimits limits = this.conversation.getLimits();
        this.logger.debug("Decoding Message with Security policy {} and encoding limits {}", (Object)this.conversation.getSecurityPolicy(), (Object)limits);
        if (message instanceof OpcuaOpenResponse || message instanceof OpcuaOpenRequest) {
            Chunk chunk = new ChunkFactory().create(true, this.conversation.isSymmetricEncryptionEnabled(), this.conversation.isSymmetricSigningEnabled(), this.conversation.getSecurityPolicy(), limits, this.conversation.getRemoteCertificate(), this.conversation.getLocalCertificate());
            return this.asymmetricEncryptionHandler.decodeMessage(chunk, message);
        }
        Chunk chunk = new ChunkFactory().create(false, this.conversation.isSymmetricEncryptionEnabled(), this.conversation.isSymmetricSigningEnabled(), this.conversation.getSecurityPolicy(), limits, this.conversation.getRemoteCertificate(), this.conversation.getLocalCertificate());
        return this.symmetricEncryptionHandler.decodeMessage(chunk, message);
    }

    public SignatureData createClientSignature() throws GeneralSecurityException {
        SecurityPolicy securityPolicy = this.conversation.getSecurityPolicy();
        byte[] lastServerNonce = this.conversation.getRemoteNonce();
        byte[] cert = Try.of(() -> this.conversation.getRemoteCertificate().getEncoded()).getOrElse(new byte[0]);
        byte[] bytes = ByteBuffer.allocate(cert.length + lastServerNonce.length).put(cert).put(lastServerNonce).array();
        byte[] signed = this.asymmetricEncryptionHandler.sign(bytes);
        return new SignatureData(new PascalString(securityPolicy.getAsymmetricSignatureAlgorithm().getUri()), new PascalByteString(signed.length, signed));
    }

    public byte[] encryptPassword(byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
            cipher.init(1, this.conversation.getRemoteCertificate().getPublicKey());
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            this.logger.error("Unable to encrypt Data", (Throwable)e);
            return null;
        }
    }
}

