/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.protocol;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.plc4x.java.api.authentication.PlcAuthentication;
import org.apache.plc4x.java.api.exceptions.PlcConnectionException;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.messages.PlcSubscriptionEvent;
import org.apache.plc4x.java.api.messages.PlcSubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcSubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionRequest;
import org.apache.plc4x.java.api.messages.PlcUnsubscriptionResponse;
import org.apache.plc4x.java.api.messages.PlcWriteRequest;
import org.apache.plc4x.java.api.messages.PlcWriteResponse;
import org.apache.plc4x.java.api.model.PlcConsumerRegistration;
import org.apache.plc4x.java.api.model.PlcSubscriptionHandle;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.types.PlcValueType;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.opcua.config.OpcuaConfiguration;
import org.apache.plc4x.java.opcua.context.Conversation;
import org.apache.plc4x.java.opcua.context.OpcuaDriverContext;
import org.apache.plc4x.java.opcua.context.SecureChannel;
import org.apache.plc4x.java.opcua.protocol.OpcuaSubscriptionHandle;
import org.apache.plc4x.java.opcua.readwrite.ByteStringArray;
import org.apache.plc4x.java.opcua.readwrite.CreateSubscriptionRequest;
import org.apache.plc4x.java.opcua.readwrite.CreateSubscriptionResponse;
import org.apache.plc4x.java.opcua.readwrite.DataValue;
import org.apache.plc4x.java.opcua.readwrite.ExpandedNodeId;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectEncodingMask;
import org.apache.plc4x.java.opcua.readwrite.GuidValue;
import org.apache.plc4x.java.opcua.readwrite.LocalizedText;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.NodeIdGuid;
import org.apache.plc4x.java.opcua.readwrite.NodeIdNumeric;
import org.apache.plc4x.java.opcua.readwrite.NodeIdString;
import org.apache.plc4x.java.opcua.readwrite.NodeIdTwoByte;
import org.apache.plc4x.java.opcua.readwrite.NullExtension;
import org.apache.plc4x.java.opcua.readwrite.OpcuaAPU;
import org.apache.plc4x.java.opcua.readwrite.OpcuaIdentifierType;
import org.apache.plc4x.java.opcua.readwrite.OpcuaStatusCode;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.opcua.readwrite.QualifiedName;
import org.apache.plc4x.java.opcua.readwrite.ReadRequest;
import org.apache.plc4x.java.opcua.readwrite.ReadResponse;
import org.apache.plc4x.java.opcua.readwrite.ReadValueId;
import org.apache.plc4x.java.opcua.readwrite.RequestHeader;
import org.apache.plc4x.java.opcua.readwrite.StatusCode;
import org.apache.plc4x.java.opcua.readwrite.TimestampsToReturn;
import org.apache.plc4x.java.opcua.readwrite.Variant;
import org.apache.plc4x.java.opcua.readwrite.VariantBoolean;
import org.apache.plc4x.java.opcua.readwrite.VariantByte;
import org.apache.plc4x.java.opcua.readwrite.VariantByteString;
import org.apache.plc4x.java.opcua.readwrite.VariantDateTime;
import org.apache.plc4x.java.opcua.readwrite.VariantDouble;
import org.apache.plc4x.java.opcua.readwrite.VariantExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.VariantFloat;
import org.apache.plc4x.java.opcua.readwrite.VariantGuid;
import org.apache.plc4x.java.opcua.readwrite.VariantInt16;
import org.apache.plc4x.java.opcua.readwrite.VariantInt32;
import org.apache.plc4x.java.opcua.readwrite.VariantInt64;
import org.apache.plc4x.java.opcua.readwrite.VariantLocalizedText;
import org.apache.plc4x.java.opcua.readwrite.VariantNodeId;
import org.apache.plc4x.java.opcua.readwrite.VariantQualifiedName;
import org.apache.plc4x.java.opcua.readwrite.VariantSByte;
import org.apache.plc4x.java.opcua.readwrite.VariantStatusCode;
import org.apache.plc4x.java.opcua.readwrite.VariantString;
import org.apache.plc4x.java.opcua.readwrite.VariantUInt16;
import org.apache.plc4x.java.opcua.readwrite.VariantUInt32;
import org.apache.plc4x.java.opcua.readwrite.VariantUInt64;
import org.apache.plc4x.java.opcua.readwrite.VariantXmlElement;
import org.apache.plc4x.java.opcua.readwrite.WriteRequest;
import org.apache.plc4x.java.opcua.readwrite.WriteResponse;
import org.apache.plc4x.java.opcua.readwrite.WriteValue;
import org.apache.plc4x.java.opcua.tag.OpcuaTag;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.context.DriverContext;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcSubscriptionResponse;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteRequest;
import org.apache.plc4x.java.spi.messages.DefaultPlcWriteResponse;
import org.apache.plc4x.java.spi.messages.PlcSubscriber;
import org.apache.plc4x.java.spi.messages.utils.ResponseItem;
import org.apache.plc4x.java.spi.model.DefaultPlcConsumerRegistration;
import org.apache.plc4x.java.spi.model.DefaultPlcSubscriptionTag;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcValueHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpcuaProtocolLogic
extends Plc4xProtocolBase<OpcuaAPU>
implements HasConfiguration<OpcuaConfiguration>,
PlcSubscriber {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpcuaProtocolLogic.class);
    protected static final PascalString NULL_STRING = new PascalString("");
    private static final ExpandedNodeId NULL_EXPANDED_NODEID = new ExpandedNodeId(false, false, new NodeIdTwoByte(0), null, null);
    protected static final ExtensionObject NULL_EXTENSION_OBJECT = new ExtensionObject(NULL_EXPANDED_NODEID, new ExtensionObjectEncodingMask(false, false, false), new NullExtension());
    private static final long EPOCH_OFFSET = 116444736000000000L;
    private final Map<Long, OpcuaSubscriptionHandle> subscriptions = new ConcurrentHashMap<Long, OpcuaSubscriptionHandle>();
    private final RequestTransactionManager tm = new RequestTransactionManager();
    private OpcuaConfiguration configuration;
    private OpcuaDriverContext driverContext;
    private SecureChannel channel;
    private Conversation conversation;

    @Override
    public void setConfiguration(OpcuaConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void close(ConversationContext<OpcuaAPU> context) {
        this.tm.shutdown();
    }

    @Override
    public void onDisconnect(ConversationContext<OpcuaAPU> context) {
        if (this.channel == null) {
            return;
        }
        for (Map.Entry<Long, OpcuaSubscriptionHandle> subscriber : this.subscriptions.entrySet()) {
            subscriber.getValue().stopSubscriber();
        }
        RequestTransactionManager.RequestTransaction tx = this.tm.startRequest();
        tx.submit(() -> {
            try {
                this.channel.onDisconnect();
                tx.endRequest();
            }
            catch (Exception e) {
                tx.failRequest(e);
            }
        });
    }

    @Override
    public void setDriverContext(DriverContext driverContext) {
        this.driverContext = (OpcuaDriverContext)driverContext;
    }

    @Override
    public void onConnect(ConversationContext<OpcuaAPU> context) {
        LOGGER.debug("Opcua Driver running in ACTIVE mode.");
        if (this.channel == null) {
            try {
                this.channel = this.createSecureChannel(context, context.getAuthentication());
            }
            catch (PlcRuntimeException ex) {
                context.getChannel().pipeline().fireExceptionCaught(new PlcConnectionException(ex));
                return;
            }
        }
        CompletableFuture future = new CompletableFuture();
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> this.channel.onConnect().whenComplete((response, error) -> OpcuaProtocolLogic.bridge(transaction, future, response, error)));
        future.whenComplete((response, error) -> {
            if (error != null) {
                LOGGER.error("Failed to establish connection", error);
                return;
            }
            LOGGER.info("Established connection to server", error);
            context.fireConnected();
        });
    }

    @Override
    public void onDiscover(ConversationContext<OpcuaAPU> context) {
        if (!this.configuration.isDiscovery()) {
            LOGGER.debug("not encrypted, ignoring onDiscover");
            context.fireDiscovered(this.configuration);
            return;
        }
        LOGGER.debug("Opcua Driver running in ACTIVE mode, discovering endpoints");
        if (this.channel == null) {
            try {
                this.channel = this.createSecureChannel(context, context.getAuthentication());
            }
            catch (PlcRuntimeException ex) {
                context.getChannel().pipeline().fireExceptionCaught(new PlcConnectionException(ex));
                return;
            }
        }
        CompletableFuture future = new CompletableFuture();
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> {
            CompletionStage completionStage = this.channel.onDiscover().whenComplete((response, error) -> OpcuaProtocolLogic.bridge(transaction, future, response, error));
        });
        future.whenComplete((response, error) -> {
            if (error != null) {
                PlcConnectionException exception = new PlcConnectionException((Throwable)error);
                context.getChannel().pipeline().fireExceptionCaught(exception);
                transaction.failRequest(exception);
                return;
            }
            this.configuration.setServerCertificate(SecureChannel.getX509Certificate(response.getServerCertificate().getStringValue()));
            context.fireDiscovered(this.configuration);
            context.fireDisconnected();
            transaction.endRequest();
        });
    }

    private SecureChannel createSecureChannel(ConversationContext<OpcuaAPU> context, PlcAuthentication authentication) {
        this.conversation = new Conversation(context, this.driverContext, this.configuration);
        return new SecureChannel(this.conversation, this.tm, this.driverContext, this.configuration, authentication);
    }

    @Override
    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        LOGGER.trace("Reading Value");
        DefaultPlcReadRequest request = (DefaultPlcReadRequest)readRequest;
        RequestHeader requestHeader = this.conversation.createRequestHeader();
        ArrayList<ExtensionObjectDefinition> readValueArray = new ArrayList<ExtensionObjectDefinition>(request.getTagNames().size());
        Iterator iterator = request.getTagNames().iterator();
        int i = 0;
        while (i < request.getTagNames().size()) {
            String tagName = (String)iterator.next();
            OpcuaTag tag = (OpcuaTag)request.getTag(tagName);
            NodeId nodeId = OpcuaProtocolLogic.generateNodeId(tag);
            readValueArray.add(new ReadValueId(nodeId, 13L, NULL_STRING, new QualifiedName(0, NULL_STRING)));
            ++i;
        }
        ReadRequest opcuaReadRequest = new ReadRequest(requestHeader, 0.0, TimestampsToReturn.timestampsToReturnNeither, readValueArray.size(), readValueArray);
        CompletableFuture future = new CompletableFuture();
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> this.conversation.submit(opcuaReadRequest, ReadResponse.class).whenComplete((response, error) -> OpcuaProtocolLogic.bridge(transaction, future, response, error)));
        return future.thenApply(response -> new DefaultPlcReadResponse(request, this.readResponse(request.getTagNames(), response.getResults())));
    }

    static NodeId generateNodeId(OpcuaTag tag) {
        NodeId nodeId = null;
        if (tag.getIdentifierType() == OpcuaIdentifierType.BINARY_IDENTIFIER) {
            nodeId = new NodeId(new NodeIdTwoByte(Short.parseShort(tag.getIdentifier())));
        } else if (tag.getIdentifierType() == OpcuaIdentifierType.NUMBER_IDENTIFIER) {
            nodeId = new NodeId(new NodeIdNumeric((short)tag.getNamespace(), Long.parseLong(tag.getIdentifier())));
        } else if (tag.getIdentifierType() == OpcuaIdentifierType.GUID_IDENTIFIER) {
            UUID guid = UUID.fromString(tag.getIdentifier());
            ByteBuffer bb = ByteBuffer.allocate(16).order(ByteOrder.LITTLE_ENDIAN).putInt((int)(guid.getMostSignificantBits() >> 32)).putShort((short)(guid.getMostSignificantBits() >> 16)).putShort((short)guid.getMostSignificantBits()).order(ByteOrder.BIG_ENDIAN).putLong(guid.getLeastSignificantBits());
            nodeId = new NodeId(new NodeIdGuid((short)tag.getNamespace(), bb.array()));
        } else if (tag.getIdentifierType() == OpcuaIdentifierType.STRING_IDENTIFIER) {
            nodeId = new NodeId(new NodeIdString((short)tag.getNamespace(), new PascalString(tag.getIdentifier())));
        }
        return nodeId;
    }

    public Map<String, ResponseItem<PlcValue>> readResponse(LinkedHashSet<String> tagNames, List<DataValue> results) {
        PlcResponseCode responseCode = null;
        HashMap<String, ResponseItem<PlcValue>> response = new HashMap<String, ResponseItem<PlcValue>>();
        int count = 0;
        for (String tagName : tagNames) {
            PlcValue value = null;
            if (results.get(count).getValueSpecified()) {
                Object[] tmpValue;
                Variant variant = results.get(count).getValue();
                LOGGER.trace("Response of type {}", (Object)variant.getClass().toString());
                if (variant instanceof VariantBoolean) {
                    byte[] array = ((VariantBoolean)variant).getValue();
                    int length = array.length;
                    tmpValue = new Boolean[length];
                    int i = 0;
                    while (i < length) {
                        tmpValue[i] = array[i] != 0;
                        ++i;
                    }
                    value = PlcValueHandler.of(tmpValue);
                } else if (variant instanceof VariantSByte) {
                    byte[] array = ((VariantSByte)variant).getValue();
                    value = PlcValueHandler.of((Object)array);
                } else if (variant instanceof VariantByte) {
                    List<Short> array = ((VariantByte)variant).getValue();
                    Object[] tmpValue2 = array.toArray(new Short[0]);
                    value = PlcValueHandler.of(tmpValue2);
                } else if (variant instanceof VariantInt16) {
                    List<Short> array = ((VariantInt16)variant).getValue();
                    Object[] tmpValue3 = array.toArray(new Short[0]);
                    value = PlcValueHandler.of(tmpValue3);
                } else if (variant instanceof VariantUInt16) {
                    List<Integer> array = ((VariantUInt16)variant).getValue();
                    Object[] tmpValue4 = array.toArray(new Integer[0]);
                    value = PlcValueHandler.of(tmpValue4);
                } else if (variant instanceof VariantInt32) {
                    List<Integer> array = ((VariantInt32)variant).getValue();
                    Object[] tmpValue5 = array.toArray(new Integer[0]);
                    value = PlcValueHandler.of(tmpValue5);
                } else if (variant instanceof VariantUInt32) {
                    List<Long> array = ((VariantUInt32)variant).getValue();
                    Object[] tmpValue6 = array.toArray(new Long[0]);
                    value = PlcValueHandler.of(tmpValue6);
                } else if (variant instanceof VariantInt64) {
                    List<Long> array = ((VariantInt64)variant).getValue();
                    Object[] tmpValue7 = array.toArray(new Long[0]);
                    value = PlcValueHandler.of(tmpValue7);
                } else if (variant instanceof VariantUInt64) {
                    value = PlcValueHandler.of(((VariantUInt64)variant).getValue());
                } else if (variant instanceof VariantFloat) {
                    List<Float> array = ((VariantFloat)variant).getValue();
                    Object[] tmpValue8 = array.toArray(new Float[0]);
                    value = PlcValueHandler.of(tmpValue8);
                } else if (variant instanceof VariantDouble) {
                    List<Double> array = ((VariantDouble)variant).getValue();
                    Object[] tmpValue9 = array.toArray(new Double[0]);
                    value = PlcValueHandler.of(tmpValue9);
                } else if (variant instanceof VariantString) {
                    int length = ((VariantString)variant).getValue().size();
                    List<PascalString> stringArray = ((VariantString)variant).getValue();
                    tmpValue = new String[length];
                    int i = 0;
                    while (i < length) {
                        tmpValue[i] = stringArray.get(i).getStringValue();
                        ++i;
                    }
                    value = PlcValueHandler.of(tmpValue);
                } else if (variant instanceof VariantDateTime) {
                    List<Long> array = ((VariantDateTime)variant).getValue();
                    int length = array.size();
                    tmpValue = new LocalDateTime[length];
                    int i = 0;
                    while (i < length) {
                        tmpValue[i] = LocalDateTime.ofInstant(Instant.ofEpochMilli(OpcuaProtocolLogic.getDateTime(array.get(i))), ZoneOffset.UTC);
                        ++i;
                    }
                    value = PlcValueHandler.of(tmpValue);
                } else if (variant instanceof VariantGuid) {
                    List<GuidValue> array = ((VariantGuid)variant).getValue();
                    int length = array.size();
                    tmpValue = new String[length];
                    int i = 0;
                    while (i < length) {
                        byte[] data4Bytes = array.get(i).getData4();
                        int data4 = 0;
                        byte[] byArray = data4Bytes;
                        int n = data4Bytes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            byte data4Byte = byArray[n2];
                            data4 = (data4 << 8) + (data4Byte & 0xFF);
                            ++n2;
                        }
                        byte[] data5Bytes = array.get(i).getData5();
                        long data5 = 0L;
                        byte[] byArray2 = data5Bytes;
                        int n3 = data5Bytes.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            byte data5Byte = byArray2[n4];
                            data5 = (data5 << 8) + (long)(data5Byte & 0xFF);
                            ++n4;
                        }
                        tmpValue[i] = String.valueOf(Long.toHexString(array.get(i).getData1())) + "-" + Integer.toHexString(array.get(i).getData2()) + "-" + Integer.toHexString(array.get(i).getData3()) + "-" + Integer.toHexString(data4) + "-" + Long.toHexString(data5);
                        ++i;
                    }
                    value = PlcValueHandler.of(tmpValue);
                } else if (variant instanceof VariantXmlElement) {
                    int length = ((VariantXmlElement)variant).getValue().size();
                    List<PascalString> strings = ((VariantXmlElement)variant).getValue();
                    tmpValue = new String[length];
                    int i = 0;
                    while (i < length) {
                        tmpValue[i] = strings.get(i).getStringValue();
                        ++i;
                    }
                    value = PlcValueHandler.of(tmpValue);
                } else if (variant instanceof VariantLocalizedText) {
                    int length = ((VariantLocalizedText)variant).getValue().size();
                    List<LocalizedText> strings = ((VariantLocalizedText)variant).getValue();
                    tmpValue = new String[length];
                    int i = 0;
                    while (i < length) {
                        tmpValue[i] = "";
                        int n = i;
                        tmpValue[n] = String.valueOf(tmpValue[n]) + (strings.get(i).getLocaleSpecified() ? String.valueOf(strings.get(i).getLocale().getStringValue()) + "|" : "");
                        int n5 = i;
                        tmpValue[n5] = String.valueOf(tmpValue[n5]) + (strings.get(i).getTextSpecified() ? strings.get(i).getText().getStringValue() : "");
                        ++i;
                    }
                    value = PlcValueHandler.of(tmpValue);
                } else if (variant instanceof VariantQualifiedName) {
                    int length = ((VariantQualifiedName)variant).getValue().size();
                    List<QualifiedName> strings = ((VariantQualifiedName)variant).getValue();
                    tmpValue = new String[length];
                    int i = 0;
                    while (i < length) {
                        tmpValue[i] = "ns=" + strings.get(i).getNamespaceIndex() + ";s=" + strings.get(i).getName().getStringValue();
                        ++i;
                    }
                    value = PlcValueHandler.of(tmpValue);
                } else if (variant instanceof VariantExtensionObject) {
                    int length = ((VariantExtensionObject)variant).getValue().size();
                    List<ExtensionObject> strings = ((VariantExtensionObject)variant).getValue();
                    tmpValue = new String[length];
                    int i = 0;
                    while (i < length) {
                        tmpValue[i] = strings.get(i).toString();
                        ++i;
                    }
                    value = PlcValueHandler.of(tmpValue);
                } else if (variant instanceof VariantNodeId) {
                    int length = ((VariantNodeId)variant).getValue().size();
                    List<NodeId> strings = ((VariantNodeId)variant).getValue();
                    tmpValue = new String[length];
                    int i = 0;
                    while (i < length) {
                        tmpValue[i] = strings.get(i).toString();
                        ++i;
                    }
                    value = PlcValueHandler.of(tmpValue);
                } else if (variant instanceof VariantStatusCode) {
                    int length = ((VariantStatusCode)variant).getValue().size();
                    List<StatusCode> strings = ((VariantStatusCode)variant).getValue();
                    tmpValue = new String[length];
                    int i = 0;
                    while (i < length) {
                        tmpValue[i] = strings.get(i).toString();
                        ++i;
                    }
                    value = PlcValueHandler.of(tmpValue);
                } else if (variant instanceof VariantByteString) {
                    PlcList plcList = new PlcList();
                    List<ByteStringArray> array = ((VariantByteString)variant).getValue();
                    for (ByteStringArray byteStringArray : array) {
                        int length = byteStringArray.getValue().size();
                        Object[] tmpValue10 = new Short[length];
                        int i = 0;
                        while (i < length) {
                            tmpValue10[i] = byteStringArray.getValue().get(i);
                            ++i;
                        }
                        plcList.add(PlcValueHandler.of(tmpValue10));
                    }
                    value = plcList;
                } else {
                    responseCode = PlcResponseCode.UNSUPPORTED;
                    LOGGER.error("Data type - " + variant.getClass() + " is not supported ");
                }
                if (PlcResponseCode.UNSUPPORTED != responseCode) {
                    responseCode = PlcResponseCode.OK;
                }
            } else {
                StatusCode statusCode = results.get(count).getStatusCode();
                responseCode = OpcuaProtocolLogic.mapOpcStatusCode(statusCode.getStatusCode(), PlcResponseCode.UNSUPPORTED);
                LOGGER.error("Error while reading value from OPC UA server error code:- " + results.get(count).getStatusCode().toString());
            }
            ++count;
            response.put(tagName, new ResponseItem<PlcValue>(responseCode, value));
        }
        return response;
    }

    private static PlcResponseCode mapOpcStatusCode(long opcStatusCode, PlcResponseCode fallback) {
        if (!OpcuaStatusCode.isDefined(opcStatusCode).booleanValue()) {
            return PlcResponseCode.INTERNAL_ERROR;
        }
        OpcuaStatusCode statusCode = OpcuaStatusCode.enumForValue(opcStatusCode);
        if (statusCode == OpcuaStatusCode.Good) {
            return PlcResponseCode.OK;
        }
        if (statusCode == OpcuaStatusCode.BadNodeIdUnknown) {
            return PlcResponseCode.NOT_FOUND;
        }
        if (statusCode == OpcuaStatusCode.BadTypeMismatch) {
            return PlcResponseCode.INVALID_DATATYPE;
        }
        if (statusCode == OpcuaStatusCode.BadNotWritable) {
            return PlcResponseCode.ACCESS_DENIED;
        }
        if (statusCode == OpcuaStatusCode.BadUserAccessDenied) {
            return PlcResponseCode.ACCESS_DENIED;
        }
        if (statusCode == OpcuaStatusCode.BadAttributeIdInvalid) {
            return PlcResponseCode.INVALID_ADDRESS;
        }
        if (statusCode == OpcuaStatusCode.BadIndexRangeNoData) {
            return PlcResponseCode.INVALID_ADDRESS;
        }
        return fallback;
    }

    private Variant fromPlcValue(String tagName, OpcuaTag tag, PlcWriteRequest request) {
        PlcList valueObject;
        if (request.getPlcValue(tagName).getObject() instanceof ArrayList) {
            valueObject = (PlcList)request.getPlcValue(tagName);
        } else {
            ArrayList<PlcValue> list = new ArrayList<PlcValue>();
            list.add(request.getPlcValue(tagName));
            valueObject = new PlcList(list);
        }
        List<PlcValue> plcValueList = valueObject.getList();
        PlcValueType dataType = tag.getPlcValueType();
        if (dataType.equals((Object)PlcValueType.NULL)) {
            if (plcValueList.get(0).getObject() instanceof Boolean) {
                dataType = PlcValueType.BOOL;
            } else if (plcValueList.get(0).getObject() instanceof Byte) {
                dataType = PlcValueType.SINT;
            } else if (plcValueList.get(0).getObject() instanceof Short) {
                dataType = PlcValueType.INT;
            } else if (plcValueList.get(0).getObject() instanceof Integer) {
                dataType = PlcValueType.DINT;
            } else if (plcValueList.get(0).getObject() instanceof Long) {
                dataType = PlcValueType.LINT;
            } else if (plcValueList.get(0).getObject() instanceof Float) {
                dataType = PlcValueType.REAL;
            } else if (plcValueList.get(0).getObject() instanceof Double) {
                dataType = PlcValueType.LREAL;
            } else if (plcValueList.get(0).getObject() instanceof String) {
                dataType = PlcValueType.STRING;
            }
        }
        int length = valueObject.getLength();
        switch (dataType) {
            case BOOL: {
                byte[] tmpBOOL = new byte[length];
                int i = 0;
                while (i < length) {
                    tmpBOOL[i] = valueObject.getIndex(i).getByte();
                    ++i;
                }
                return new VariantBoolean(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpBOOL);
            }
            case BYTE: {
                ArrayList<Short> tmpBYTE = new ArrayList<Short>(length);
                int i = 0;
                while (i < length) {
                    tmpBYTE.add(valueObject.getIndex(i).getShort());
                    ++i;
                }
                return new VariantByte(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpBYTE);
            }
            case WORD: {
                ArrayList<Integer> tmpWORD = new ArrayList<Integer>(length);
                int i = 0;
                while (i < length) {
                    tmpWORD.add(valueObject.getIndex(i).getInteger());
                    ++i;
                }
                return new VariantUInt16(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpWORD);
            }
            case DWORD: {
                ArrayList<Long> tmpDWORD = new ArrayList<Long>(length);
                int i = 0;
                while (i < length) {
                    tmpDWORD.add(valueObject.getIndex(i).getLong());
                    ++i;
                }
                return new VariantUInt32(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpDWORD);
            }
            case LWORD: {
                ArrayList<BigInteger> tmpLWORD = new ArrayList<BigInteger>(length);
                int i = 0;
                while (i < length) {
                    tmpLWORD.add(valueObject.getIndex(i).getBigInteger());
                    ++i;
                }
                return new VariantUInt64(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpLWORD);
            }
            case USINT: {
                ArrayList<Short> tmpUSINT = new ArrayList<Short>(length);
                int i = 0;
                while (i < length) {
                    tmpUSINT.add(valueObject.getIndex(i).getShort());
                    ++i;
                }
                return new VariantByte(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpUSINT);
            }
            case SINT: {
                byte[] tmpSINT = new byte[length];
                int i = 0;
                while (i < length) {
                    tmpSINT[i] = valueObject.getIndex(i).getByte();
                    ++i;
                }
                return new VariantSByte(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpSINT);
            }
            case UINT: {
                ArrayList<Integer> tmpUINT = new ArrayList<Integer>(length);
                int i = 0;
                while (i < length) {
                    tmpUINT.add(valueObject.getIndex(i).getInt());
                    ++i;
                }
                return new VariantUInt16(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpUINT);
            }
            case INT: {
                ArrayList<Short> tmpINT16 = new ArrayList<Short>(length);
                int i = 0;
                while (i < length) {
                    tmpINT16.add(valueObject.getIndex(i).getShort());
                    ++i;
                }
                return new VariantInt16(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpINT16);
            }
            case UDINT: {
                ArrayList<Long> tmpUDINT = new ArrayList<Long>(length);
                int i = 0;
                while (i < length) {
                    tmpUDINT.add(valueObject.getIndex(i).getLong());
                    ++i;
                }
                return new VariantUInt32(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpUDINT);
            }
            case DINT: {
                ArrayList<Integer> tmpDINT = new ArrayList<Integer>(length);
                int i = 0;
                while (i < length) {
                    tmpDINT.add(valueObject.getIndex(i).getInt());
                    ++i;
                }
                return new VariantInt32(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpDINT);
            }
            case ULINT: {
                ArrayList<BigInteger> tmpULINT = new ArrayList<BigInteger>(length);
                int i = 0;
                while (i < length) {
                    tmpULINT.add(valueObject.getIndex(i).getBigInteger());
                    ++i;
                }
                return new VariantUInt64(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpULINT);
            }
            case LINT: {
                ArrayList<Long> tmpLINT = new ArrayList<Long>(length);
                int i = 0;
                while (i < length) {
                    tmpLINT.add(valueObject.getIndex(i).getLong());
                    ++i;
                }
                return new VariantInt64(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpLINT);
            }
            case REAL: {
                ArrayList<Float> tmpREAL = new ArrayList<Float>(length);
                int i = 0;
                while (i < length) {
                    tmpREAL.add(Float.valueOf(valueObject.getIndex(i).getFloat()));
                    ++i;
                }
                return new VariantFloat(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpREAL);
            }
            case LREAL: {
                ArrayList<Double> tmpLREAL = new ArrayList<Double>(length);
                int i = 0;
                while (i < length) {
                    tmpLREAL.add(valueObject.getIndex(i).getDouble());
                    ++i;
                }
                return new VariantDouble(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpLREAL);
            }
            case CHAR: 
            case WCHAR: 
            case STRING: 
            case WSTRING: {
                ArrayList<PascalString> tmpString = new ArrayList<PascalString>(length);
                int i = 0;
                while (i < length) {
                    String s = valueObject.getIndex(i).getString();
                    tmpString.add(new PascalString(s));
                    ++i;
                }
                return new VariantString(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpString);
            }
            case DATE_AND_TIME: {
                ArrayList<Long> tmpDateTime = new ArrayList<Long>(length);
                int i = 0;
                while (i < length) {
                    tmpDateTime.add(valueObject.getIndex(i).getDateTime().toEpochSecond(ZoneOffset.UTC));
                    ++i;
                }
                return new VariantDateTime(length != 1, false, null, null, length == 1 ? null : Integer.valueOf(length), tmpDateTime);
            }
        }
        throw new PlcRuntimeException("Unsupported write tag type " + (Object)((Object)dataType));
    }

    @Override
    public CompletableFuture<PlcWriteResponse> write(PlcWriteRequest writeRequest) {
        LOGGER.trace("Writing Value");
        DefaultPlcWriteRequest request = (DefaultPlcWriteRequest)writeRequest;
        RequestHeader requestHeader = this.conversation.createRequestHeader();
        ArrayList<ExtensionObjectDefinition> writeValueList = new ArrayList<ExtensionObjectDefinition>(request.getTagNames().size());
        for (String tagName : request.getTagNames()) {
            OpcuaTag tag = (OpcuaTag)request.getTag(tagName);
            NodeId nodeId = OpcuaProtocolLogic.generateNodeId(tag);
            writeValueList.add(new WriteValue(nodeId, 13L, NULL_STRING, new DataValue(false, false, false, false, false, true, this.fromPlcValue(tagName, tag, writeRequest), null, null, null, null, null)));
        }
        WriteRequest opcuaWriteRequest = new WriteRequest(requestHeader, writeValueList.size(), writeValueList);
        CompletableFuture future = new CompletableFuture();
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> this.conversation.submit(opcuaWriteRequest, WriteResponse.class).whenComplete((response, error) -> OpcuaProtocolLogic.bridge(transaction, future, response, error)));
        return future.thenApply(response -> this.writeResponse(request, (WriteResponse)response));
    }

    private PlcWriteResponse writeResponse(DefaultPlcWriteRequest request, WriteResponse writeResponse) {
        HashMap<String, PlcResponseCode> responseMap = new HashMap<String, PlcResponseCode>();
        List<StatusCode> results = writeResponse.getResults();
        Iterator responseIterator = request.getTagNames().iterator();
        int i = 0;
        while (i < request.getTagNames().size()) {
            String tagName = (String)responseIterator.next();
            long opcStatusCode = results.get(i).getStatusCode();
            PlcResponseCode statusCode = OpcuaProtocolLogic.mapOpcStatusCode(opcStatusCode, PlcResponseCode.REMOTE_ERROR);
            responseMap.put(tagName, statusCode);
            ++i;
        }
        return new DefaultPlcWriteResponse(request, responseMap);
    }

    @Override
    public CompletableFuture<PlcSubscriptionResponse> subscribe(PlcSubscriptionRequest subscriptionRequest) {
        ArrayList<String> tagNames = new ArrayList<String>(subscriptionRequest.getTagNames());
        long cycleTime = subscriptionRequest.getTag((String)tagNames.get(0)).getDuration().orElse(Duration.ofMillis(1000L)).toMillis();
        CompletableFuture<PlcSubscriptionResponse> future = new CompletableFuture<PlcSubscriptionResponse>();
        RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
        transaction.submit(() -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.onSubscribeCreateSubscription(cycleTime).thenApply(response -> {
            long subscriptionId = response.getSubscriptionId();
            OpcuaSubscriptionHandle handle = new OpcuaSubscriptionHandle(this, this.tm, this.conversation, subscriptionRequest, subscriptionId, cycleTime);
            this.subscriptions.put(handle.getSubscriptionId(), handle);
            return handle;
        })).thenCompose(handle -> handle.onSubscribeCreateMonitoredItemsRequest())).thenApply(handle -> {
            HashMap<String, ResponseItem<PlcSubscriptionHandle>> values = new HashMap<String, ResponseItem<PlcSubscriptionHandle>>();
            for (String tagName : subscriptionRequest.getTagNames()) {
                DefaultPlcSubscriptionTag tagDefaultPlcSubscription = (DefaultPlcSubscriptionTag)subscriptionRequest.getTag(tagName);
                if (!(tagDefaultPlcSubscription.getTag() instanceof OpcuaTag)) {
                    values.put(tagName, new ResponseItem<Object>(PlcResponseCode.INVALID_ADDRESS, null));
                    continue;
                }
                values.put(tagName, new ResponseItem<OpcuaSubscriptionHandle>(PlcResponseCode.OK, (OpcuaSubscriptionHandle)handle));
            }
            return new DefaultPlcSubscriptionResponse(subscriptionRequest, values);
        })).whenComplete((response, error) -> OpcuaProtocolLogic.bridge(transaction, future, response, error)));
        return future;
    }

    protected void requestSubscriptionPublish() {
    }

    private CompletableFuture<CreateSubscriptionResponse> onSubscribeCreateSubscription(long cycleTime) {
        LOGGER.trace("Entering creating subscription request");
        RequestHeader requestHeader = this.conversation.createRequestHeader();
        CreateSubscriptionRequest createSubscriptionRequest = new CreateSubscriptionRequest(requestHeader, cycleTime, 12000L, 5L, 65536L, true, 0);
        return this.conversation.submit(createSubscriptionRequest, CreateSubscriptionResponse.class);
    }

    @Override
    public CompletableFuture<PlcUnsubscriptionResponse> unsubscribe(PlcUnsubscriptionRequest unsubscriptionRequest) {
        unsubscriptionRequest.getSubscriptionHandles().forEach(o -> {
            OpcuaSubscriptionHandle opcuaSubHandle = (OpcuaSubscriptionHandle)o;
            opcuaSubHandle.stopSubscriber();
        });
        return null;
    }

    public void removeSubscription(Long subscriptionId) {
        this.subscriptions.remove(subscriptionId);
    }

    @Override
    public PlcConsumerRegistration register(Consumer<PlcSubscriptionEvent> consumer, Collection<PlcSubscriptionHandle> handles) {
        LinkedList<PlcConsumerRegistration> registrations = new LinkedList<PlcConsumerRegistration>();
        for (PlcSubscriptionHandle subscriptionHandle : handles) {
            LOGGER.debug("Registering Consumer");
            PlcConsumerRegistration consumerRegistration = subscriptionHandle.register(consumer);
            registrations.add(consumerRegistration);
        }
        return new DefaultPlcConsumerRegistration(this, consumer, handles.toArray(new PlcSubscriptionHandle[0]));
    }

    @Override
    public void unregister(PlcConsumerRegistration registration) {
        registration.unregister();
    }

    public static long getDateTime(long dateTime) {
        return (dateTime - 116444736000000000L) / 10000L;
    }

    private GuidValue toGuidValue(String identifier) {
        LOGGER.error("Querying Guid nodes is not supported");
        byte[] data4 = new byte[2];
        byte[] data5 = new byte[6];
        return new GuidValue(0L, 0, 0, data4, data5);
    }

    private static <T> void bridge(RequestTransactionManager.RequestTransaction transaction, CompletableFuture<T> future, T response, Throwable error) {
        if (error != null) {
            future.completeExceptionally(error);
            transaction.failRequest(error);
        } else {
            future.complete(response);
            transaction.endRequest();
        }
    }
}

