/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DiagnosticInfo;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.opcua.readwrite.StatusCode;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class ActivateSessionResponse
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition responseHeader;
    protected final PascalByteString serverNonce;
    protected final int noOfResults;
    protected final List<StatusCode> results;
    protected final int noOfDiagnosticInfos;
    protected final List<DiagnosticInfo> diagnosticInfos;

    @Override
    public String getIdentifier() {
        return "470";
    }

    public ActivateSessionResponse(ExtensionObjectDefinition responseHeader, PascalByteString serverNonce, int noOfResults, List<StatusCode> results, int noOfDiagnosticInfos, List<DiagnosticInfo> diagnosticInfos) {
        this.responseHeader = responseHeader;
        this.serverNonce = serverNonce;
        this.noOfResults = noOfResults;
        this.results = results;
        this.noOfDiagnosticInfos = noOfDiagnosticInfos;
        this.diagnosticInfos = diagnosticInfos;
    }

    public ExtensionObjectDefinition getResponseHeader() {
        return this.responseHeader;
    }

    public PascalByteString getServerNonce() {
        return this.serverNonce;
    }

    public int getNoOfResults() {
        return this.noOfResults;
    }

    public List<StatusCode> getResults() {
        return this.results;
    }

    public int getNoOfDiagnosticInfos() {
        return this.noOfDiagnosticInfos;
    }

    public List<DiagnosticInfo> getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ActivateSessionResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("responseHeader", this.responseHeader, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("serverNonce", this.serverNonce, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfResults", this.noOfResults, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("results", this.results, writeBuffer, new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfDiagnosticInfos", this.noOfDiagnosticInfos, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("diagnosticInfos", this.diagnosticInfos, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("ActivateSessionResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        ActivateSessionResponse _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.responseHeader.getLengthInBits();
        lengthInBits += this.serverNonce.getLengthInBits();
        lengthInBits += 32;
        if (this.results != null) {
            i = 0;
            for (StatusCode statusCode : this.results) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.results.size());
                lengthInBits += statusCode.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.diagnosticInfos != null) {
            i = 0;
            for (DiagnosticInfo diagnosticInfo : this.diagnosticInfos) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.diagnosticInfos.size());
                lengthInBits += diagnosticInfo.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("ActivateSessionResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObjectDefinition responseHeader = FieldReaderFactory.readSimpleField("responseHeader", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "394"), readBuffer), new WithReaderArgs[0]);
        PascalByteString serverNonce = FieldReaderFactory.readSimpleField("serverNonce", new DataReaderComplexDefault<PascalByteString>(() -> PascalByteString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        int noOfResults = FieldReaderFactory.readSimpleField("noOfResults", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<StatusCode> results = FieldReaderFactory.readCountArrayField("results", new DataReaderComplexDefault<StatusCode>(() -> StatusCode.staticParse(readBuffer), readBuffer), noOfResults, new WithReaderArgs[0]);
        int noOfDiagnosticInfos = FieldReaderFactory.readSimpleField("noOfDiagnosticInfos", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<DiagnosticInfo> diagnosticInfos = FieldReaderFactory.readCountArrayField("diagnosticInfos", new DataReaderComplexDefault<DiagnosticInfo>(() -> DiagnosticInfo.staticParse(readBuffer), readBuffer), noOfDiagnosticInfos, new WithReaderArgs[0]);
        readBuffer.closeContext("ActivateSessionResponse", new WithReaderArgs[0]);
        return new ActivateSessionResponseBuilderImpl(responseHeader, serverNonce, noOfResults, results, noOfDiagnosticInfos, diagnosticInfos);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActivateSessionResponse)) {
            return false;
        }
        ActivateSessionResponse that = (ActivateSessionResponse)o;
        return this.getResponseHeader() == that.getResponseHeader() && this.getServerNonce() == that.getServerNonce() && this.getNoOfResults() == that.getNoOfResults() && this.getResults() == that.getResults() && this.getNoOfDiagnosticInfos() == that.getNoOfDiagnosticInfos() && this.getDiagnosticInfos() == that.getDiagnosticInfos() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getResponseHeader(), this.getServerNonce(), this.getNoOfResults(), this.getResults(), this.getNoOfDiagnosticInfos(), this.getDiagnosticInfos());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ActivateSessionResponseBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition responseHeader;
        private final PascalByteString serverNonce;
        private final int noOfResults;
        private final List<StatusCode> results;
        private final int noOfDiagnosticInfos;
        private final List<DiagnosticInfo> diagnosticInfos;

        public ActivateSessionResponseBuilderImpl(ExtensionObjectDefinition responseHeader, PascalByteString serverNonce, int noOfResults, List<StatusCode> results, int noOfDiagnosticInfos, List<DiagnosticInfo> diagnosticInfos) {
            this.responseHeader = responseHeader;
            this.serverNonce = serverNonce;
            this.noOfResults = noOfResults;
            this.results = results;
            this.noOfDiagnosticInfos = noOfDiagnosticInfos;
            this.diagnosticInfos = diagnosticInfos;
        }

        @Override
        public ActivateSessionResponse build() {
            ActivateSessionResponse activateSessionResponse = new ActivateSessionResponse(this.responseHeader, this.serverNonce, this.noOfResults, this.results, this.noOfDiagnosticInfos, this.diagnosticInfos);
            return activateSessionResponse;
        }
    }
}

