/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ApplicationType;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.LocalizedText;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class ApplicationDescription
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString applicationUri;
    protected final PascalString productUri;
    protected final LocalizedText applicationName;
    protected final ApplicationType applicationType;
    protected final PascalString gatewayServerUri;
    protected final PascalString discoveryProfileUri;
    protected final int noOfDiscoveryUrls;
    protected final List<PascalString> discoveryUrls;

    @Override
    public String getIdentifier() {
        return "310";
    }

    public ApplicationDescription(PascalString applicationUri, PascalString productUri, LocalizedText applicationName, ApplicationType applicationType, PascalString gatewayServerUri, PascalString discoveryProfileUri, int noOfDiscoveryUrls, List<PascalString> discoveryUrls) {
        this.applicationUri = applicationUri;
        this.productUri = productUri;
        this.applicationName = applicationName;
        this.applicationType = applicationType;
        this.gatewayServerUri = gatewayServerUri;
        this.discoveryProfileUri = discoveryProfileUri;
        this.noOfDiscoveryUrls = noOfDiscoveryUrls;
        this.discoveryUrls = discoveryUrls;
    }

    public PascalString getApplicationUri() {
        return this.applicationUri;
    }

    public PascalString getProductUri() {
        return this.productUri;
    }

    public LocalizedText getApplicationName() {
        return this.applicationName;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public PascalString getGatewayServerUri() {
        return this.gatewayServerUri;
    }

    public PascalString getDiscoveryProfileUri() {
        return this.discoveryProfileUri;
    }

    public int getNoOfDiscoveryUrls() {
        return this.noOfDiscoveryUrls;
    }

    public List<PascalString> getDiscoveryUrls() {
        return this.discoveryUrls;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ApplicationDescription", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("applicationUri", this.applicationUri, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("productUri", this.productUri, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("applicationName", this.applicationName, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField("applicationType", "ApplicationType", this.applicationType, new DataWriterEnumDefault<ApplicationType, Long>(ApplicationType::getValue, Enum::name, DataWriterFactory.writeUnsignedLong(writeBuffer, 32)), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("gatewayServerUri", this.gatewayServerUri, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("discoveryProfileUri", this.discoveryProfileUri, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfDiscoveryUrls", this.noOfDiscoveryUrls, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("discoveryUrls", this.discoveryUrls, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("ApplicationDescription", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ApplicationDescription _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.applicationUri.getLengthInBits();
        lengthInBits += this.productUri.getLengthInBits();
        lengthInBits += this.applicationName.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += this.gatewayServerUri.getLengthInBits();
        lengthInBits += this.discoveryProfileUri.getLengthInBits();
        lengthInBits += 32;
        if (this.discoveryUrls != null) {
            int i = 0;
            for (PascalString element : this.discoveryUrls) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.discoveryUrls.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("ApplicationDescription", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString applicationUri = FieldReaderFactory.readSimpleField("applicationUri", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        PascalString productUri = FieldReaderFactory.readSimpleField("productUri", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        LocalizedText applicationName = FieldReaderFactory.readSimpleField("applicationName", new DataReaderComplexDefault<LocalizedText>(() -> LocalizedText.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        ApplicationType applicationType = (ApplicationType)((Object)FieldReaderFactory.readEnumField("applicationType", "ApplicationType", new DataReaderEnumDefault<ApplicationType, Long>(ApplicationType::enumForValue, DataReaderFactory.readUnsignedLong(readBuffer, 32)), new WithReaderArgs[0]));
        PascalString gatewayServerUri = FieldReaderFactory.readSimpleField("gatewayServerUri", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        PascalString discoveryProfileUri = FieldReaderFactory.readSimpleField("discoveryProfileUri", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        int noOfDiscoveryUrls = FieldReaderFactory.readSimpleField("noOfDiscoveryUrls", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<PascalString> discoveryUrls = FieldReaderFactory.readCountArrayField("discoveryUrls", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), noOfDiscoveryUrls, new WithReaderArgs[0]);
        readBuffer.closeContext("ApplicationDescription", new WithReaderArgs[0]);
        return new ApplicationDescriptionBuilderImpl(applicationUri, productUri, applicationName, applicationType, gatewayServerUri, discoveryProfileUri, noOfDiscoveryUrls, discoveryUrls);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApplicationDescription)) {
            return false;
        }
        ApplicationDescription that = (ApplicationDescription)o;
        return this.getApplicationUri() == that.getApplicationUri() && this.getProductUri() == that.getProductUri() && this.getApplicationName() == that.getApplicationName() && this.getApplicationType() == that.getApplicationType() && this.getGatewayServerUri() == that.getGatewayServerUri() && this.getDiscoveryProfileUri() == that.getDiscoveryProfileUri() && this.getNoOfDiscoveryUrls() == that.getNoOfDiscoveryUrls() && this.getDiscoveryUrls() == that.getDiscoveryUrls() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getApplicationUri(), this.getProductUri(), this.getApplicationName(), this.getApplicationType(), this.getGatewayServerUri(), this.getDiscoveryProfileUri(), this.getNoOfDiscoveryUrls(), this.getDiscoveryUrls()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ApplicationDescriptionBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString applicationUri;
        private final PascalString productUri;
        private final LocalizedText applicationName;
        private final ApplicationType applicationType;
        private final PascalString gatewayServerUri;
        private final PascalString discoveryProfileUri;
        private final int noOfDiscoveryUrls;
        private final List<PascalString> discoveryUrls;

        public ApplicationDescriptionBuilderImpl(PascalString applicationUri, PascalString productUri, LocalizedText applicationName, ApplicationType applicationType, PascalString gatewayServerUri, PascalString discoveryProfileUri, int noOfDiscoveryUrls, List<PascalString> discoveryUrls) {
            this.applicationUri = applicationUri;
            this.productUri = productUri;
            this.applicationName = applicationName;
            this.applicationType = applicationType;
            this.gatewayServerUri = gatewayServerUri;
            this.discoveryProfileUri = discoveryProfileUri;
            this.noOfDiscoveryUrls = noOfDiscoveryUrls;
            this.discoveryUrls = discoveryUrls;
        }

        @Override
        public ApplicationDescription build() {
            ApplicationDescription applicationDescription = new ApplicationDescription(this.applicationUri, this.productUri, this.applicationName, this.applicationType, this.gatewayServerUri, this.discoveryProfileUri, this.noOfDiscoveryUrls, this.discoveryUrls);
            return applicationDescription;
        }
    }
}

