/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.LocalizedText;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class Argument
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString name;
    protected final NodeId dataType;
    protected final int valueRank;
    protected final int noOfArrayDimensions;
    protected final List<Long> arrayDimensions;
    protected final LocalizedText description;

    @Override
    public String getIdentifier() {
        return "298";
    }

    public Argument(PascalString name, NodeId dataType, int valueRank, int noOfArrayDimensions, List<Long> arrayDimensions, LocalizedText description) {
        this.name = name;
        this.dataType = dataType;
        this.valueRank = valueRank;
        this.noOfArrayDimensions = noOfArrayDimensions;
        this.arrayDimensions = arrayDimensions;
        this.description = description;
    }

    public PascalString getName() {
        return this.name;
    }

    public NodeId getDataType() {
        return this.dataType;
    }

    public int getValueRank() {
        return this.valueRank;
    }

    public int getNoOfArrayDimensions() {
        return this.noOfArrayDimensions;
    }

    public List<Long> getArrayDimensions() {
        return this.arrayDimensions;
    }

    public LocalizedText getDescription() {
        return this.description;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("Argument", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("name", this.name, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("dataType", this.dataType, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("valueRank", this.valueRank, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfArrayDimensions", this.noOfArrayDimensions, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField("arrayDimensions", this.arrayDimensions, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("description", this.description, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("Argument", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        Argument _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.name.getLengthInBits();
        lengthInBits += this.dataType.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.arrayDimensions != null) {
            lengthInBits += 32 * this.arrayDimensions.size();
        }
        return lengthInBits += this.description.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("Argument", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString name = FieldReaderFactory.readSimpleField("name", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        NodeId dataType = FieldReaderFactory.readSimpleField("dataType", new DataReaderComplexDefault<NodeId>(() -> NodeId.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        int valueRank = FieldReaderFactory.readSimpleField("valueRank", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        int noOfArrayDimensions = FieldReaderFactory.readSimpleField("noOfArrayDimensions", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<Long> arrayDimensions = FieldReaderFactory.readCountArrayField("arrayDimensions", DataReaderFactory.readUnsignedLong(readBuffer, 32), noOfArrayDimensions, new WithReaderArgs[0]);
        LocalizedText description = FieldReaderFactory.readSimpleField("description", new DataReaderComplexDefault<LocalizedText>(() -> LocalizedText.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("Argument", new WithReaderArgs[0]);
        return new ArgumentBuilderImpl(name, dataType, valueRank, noOfArrayDimensions, arrayDimensions, description);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Argument)) {
            return false;
        }
        Argument that = (Argument)o;
        return this.getName() == that.getName() && this.getDataType() == that.getDataType() && this.getValueRank() == that.getValueRank() && this.getNoOfArrayDimensions() == that.getNoOfArrayDimensions() && this.getArrayDimensions() == that.getArrayDimensions() && this.getDescription() == that.getDescription() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getName(), this.getDataType(), this.getValueRank(), this.getNoOfArrayDimensions(), this.getArrayDimensions(), this.getDescription());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ArgumentBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString name;
        private final NodeId dataType;
        private final int valueRank;
        private final int noOfArrayDimensions;
        private final List<Long> arrayDimensions;
        private final LocalizedText description;

        public ArgumentBuilderImpl(PascalString name, NodeId dataType, int valueRank, int noOfArrayDimensions, List<Long> arrayDimensions, LocalizedText description) {
            this.name = name;
            this.dataType = dataType;
            this.valueRank = valueRank;
            this.noOfArrayDimensions = noOfArrayDimensions;
            this.arrayDimensions = arrayDimensions;
            this.description = description;
        }

        @Override
        public Argument build() {
            Argument argument = new Argument(this.name, this.dataType, this.valueRank, this.noOfArrayDimensions, this.arrayDimensions, this.description);
            return argument;
        }
    }
}

