/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class BrowseNextRequest
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition requestHeader;
    protected final boolean releaseContinuationPoints;
    protected final int noOfContinuationPoints;
    protected final List<PascalByteString> continuationPoints;

    @Override
    public String getIdentifier() {
        return "533";
    }

    public BrowseNextRequest(ExtensionObjectDefinition requestHeader, boolean releaseContinuationPoints, int noOfContinuationPoints, List<PascalByteString> continuationPoints) {
        this.requestHeader = requestHeader;
        this.releaseContinuationPoints = releaseContinuationPoints;
        this.noOfContinuationPoints = noOfContinuationPoints;
        this.continuationPoints = continuationPoints;
    }

    public ExtensionObjectDefinition getRequestHeader() {
        return this.requestHeader;
    }

    public boolean getReleaseContinuationPoints() {
        return this.releaseContinuationPoints;
    }

    public int getNoOfContinuationPoints() {
        return this.noOfContinuationPoints;
    }

    public List<PascalByteString> getContinuationPoints() {
        return this.continuationPoints;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BrowseNextRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("requestHeader", this.requestHeader, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField("reserved", (byte)0, DataWriterFactory.writeUnsignedByte(writeBuffer, 7), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("releaseContinuationPoints", this.releaseContinuationPoints, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfContinuationPoints", this.noOfContinuationPoints, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("continuationPoints", this.continuationPoints, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("BrowseNextRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BrowseNextRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 7;
        ++lengthInBits;
        lengthInBits += 32;
        if (this.continuationPoints != null) {
            int i = 0;
            for (PascalByteString element : this.continuationPoints) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.continuationPoints.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("BrowseNextRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObjectDefinition requestHeader = FieldReaderFactory.readSimpleField("requestHeader", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "391"), readBuffer), new WithReaderArgs[0]);
        Byte reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 7), (byte)0, new WithReaderArgs[0]);
        boolean releaseContinuationPoints = FieldReaderFactory.readSimpleField("releaseContinuationPoints", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
        int noOfContinuationPoints = FieldReaderFactory.readSimpleField("noOfContinuationPoints", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<PascalByteString> continuationPoints = FieldReaderFactory.readCountArrayField("continuationPoints", new DataReaderComplexDefault<PascalByteString>(() -> PascalByteString.staticParse(readBuffer), readBuffer), noOfContinuationPoints, new WithReaderArgs[0]);
        readBuffer.closeContext("BrowseNextRequest", new WithReaderArgs[0]);
        return new BrowseNextRequestBuilderImpl(requestHeader, releaseContinuationPoints, noOfContinuationPoints, continuationPoints);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BrowseNextRequest)) {
            return false;
        }
        BrowseNextRequest that = (BrowseNextRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getReleaseContinuationPoints() == that.getReleaseContinuationPoints() && this.getNoOfContinuationPoints() == that.getNoOfContinuationPoints() && this.getContinuationPoints() == that.getContinuationPoints() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getReleaseContinuationPoints(), this.getNoOfContinuationPoints(), this.getContinuationPoints());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BrowseNextRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition requestHeader;
        private final boolean releaseContinuationPoints;
        private final int noOfContinuationPoints;
        private final List<PascalByteString> continuationPoints;

        public BrowseNextRequestBuilderImpl(ExtensionObjectDefinition requestHeader, boolean releaseContinuationPoints, int noOfContinuationPoints, List<PascalByteString> continuationPoints) {
            this.requestHeader = requestHeader;
            this.releaseContinuationPoints = releaseContinuationPoints;
            this.noOfContinuationPoints = noOfContinuationPoints;
            this.continuationPoints = continuationPoints;
        }

        @Override
        public BrowseNextRequest build() {
            BrowseNextRequest browseNextRequest = new BrowseNextRequest(this.requestHeader, this.releaseContinuationPoints, this.noOfContinuationPoints, this.continuationPoints);
            return browseNextRequest;
        }
    }
}

