/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.opcua.readwrite.StatusCode;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class BrowseResult
extends ExtensionObjectDefinition
implements Message {
    protected final StatusCode statusCode;
    protected final PascalByteString continuationPoint;
    protected final int noOfReferences;
    protected final List<ExtensionObjectDefinition> references;

    @Override
    public String getIdentifier() {
        return "524";
    }

    public BrowseResult(StatusCode statusCode, PascalByteString continuationPoint, int noOfReferences, List<ExtensionObjectDefinition> references) {
        this.statusCode = statusCode;
        this.continuationPoint = continuationPoint;
        this.noOfReferences = noOfReferences;
        this.references = references;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public PascalByteString getContinuationPoint() {
        return this.continuationPoint;
    }

    public int getNoOfReferences() {
        return this.noOfReferences;
    }

    public List<ExtensionObjectDefinition> getReferences() {
        return this.references;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BrowseResult", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("statusCode", this.statusCode, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("continuationPoint", this.continuationPoint, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfReferences", this.noOfReferences, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("references", this.references, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("BrowseResult", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BrowseResult _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.statusCode.getLengthInBits();
        lengthInBits += this.continuationPoint.getLengthInBits();
        lengthInBits += 32;
        if (this.references != null) {
            int i = 0;
            for (ExtensionObjectDefinition element : this.references) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.references.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("BrowseResult", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        StatusCode statusCode = FieldReaderFactory.readSimpleField("statusCode", new DataReaderComplexDefault<StatusCode>(() -> StatusCode.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        PascalByteString continuationPoint = FieldReaderFactory.readSimpleField("continuationPoint", new DataReaderComplexDefault<PascalByteString>(() -> PascalByteString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        int noOfReferences = FieldReaderFactory.readSimpleField("noOfReferences", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<ExtensionObjectDefinition> references = FieldReaderFactory.readCountArrayField("references", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "520"), readBuffer), noOfReferences, new WithReaderArgs[0]);
        readBuffer.closeContext("BrowseResult", new WithReaderArgs[0]);
        return new BrowseResultBuilderImpl(statusCode, continuationPoint, noOfReferences, references);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BrowseResult)) {
            return false;
        }
        BrowseResult that = (BrowseResult)o;
        return this.getStatusCode() == that.getStatusCode() && this.getContinuationPoint() == that.getContinuationPoint() && this.getNoOfReferences() == that.getNoOfReferences() && this.getReferences() == that.getReferences() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getStatusCode(), this.getContinuationPoint(), this.getNoOfReferences(), this.getReferences());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BrowseResultBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final StatusCode statusCode;
        private final PascalByteString continuationPoint;
        private final int noOfReferences;
        private final List<ExtensionObjectDefinition> references;

        public BrowseResultBuilderImpl(StatusCode statusCode, PascalByteString continuationPoint, int noOfReferences, List<ExtensionObjectDefinition> references) {
            this.statusCode = statusCode;
            this.continuationPoint = continuationPoint;
            this.noOfReferences = noOfReferences;
            this.references = references;
        }

        @Override
        public BrowseResult build() {
            BrowseResult browseResult = new BrowseResult(this.statusCode, this.continuationPoint, this.noOfReferences, this.references);
            return browseResult;
        }
    }
}

