/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.Variant;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class CallMethodRequest
extends ExtensionObjectDefinition
implements Message {
    protected final NodeId objectId;
    protected final NodeId methodId;
    protected final int noOfInputArguments;
    protected final List<Variant> inputArguments;

    @Override
    public String getIdentifier() {
        return "706";
    }

    public CallMethodRequest(NodeId objectId, NodeId methodId, int noOfInputArguments, List<Variant> inputArguments) {
        this.objectId = objectId;
        this.methodId = methodId;
        this.noOfInputArguments = noOfInputArguments;
        this.inputArguments = inputArguments;
    }

    public NodeId getObjectId() {
        return this.objectId;
    }

    public NodeId getMethodId() {
        return this.methodId;
    }

    public int getNoOfInputArguments() {
        return this.noOfInputArguments;
    }

    public List<Variant> getInputArguments() {
        return this.inputArguments;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CallMethodRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("objectId", this.objectId, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("methodId", this.methodId, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfInputArguments", this.noOfInputArguments, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("inputArguments", this.inputArguments, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("CallMethodRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        CallMethodRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.objectId.getLengthInBits();
        lengthInBits += this.methodId.getLengthInBits();
        lengthInBits += 32;
        if (this.inputArguments != null) {
            int i = 0;
            for (Variant element : this.inputArguments) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.inputArguments.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("CallMethodRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        NodeId objectId = FieldReaderFactory.readSimpleField("objectId", new DataReaderComplexDefault<NodeId>(() -> NodeId.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        NodeId methodId = FieldReaderFactory.readSimpleField("methodId", new DataReaderComplexDefault<NodeId>(() -> NodeId.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        int noOfInputArguments = FieldReaderFactory.readSimpleField("noOfInputArguments", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<Variant> inputArguments = FieldReaderFactory.readCountArrayField("inputArguments", new DataReaderComplexDefault<Variant>(() -> Variant.staticParse(readBuffer), readBuffer), noOfInputArguments, new WithReaderArgs[0]);
        readBuffer.closeContext("CallMethodRequest", new WithReaderArgs[0]);
        return new CallMethodRequestBuilderImpl(objectId, methodId, noOfInputArguments, inputArguments);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CallMethodRequest)) {
            return false;
        }
        CallMethodRequest that = (CallMethodRequest)o;
        return this.getObjectId() == that.getObjectId() && this.getMethodId() == that.getMethodId() && this.getNoOfInputArguments() == that.getNoOfInputArguments() && this.getInputArguments() == that.getInputArguments() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getObjectId(), this.getMethodId(), this.getNoOfInputArguments(), this.getInputArguments());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CallMethodRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final NodeId objectId;
        private final NodeId methodId;
        private final int noOfInputArguments;
        private final List<Variant> inputArguments;

        public CallMethodRequestBuilderImpl(NodeId objectId, NodeId methodId, int noOfInputArguments, List<Variant> inputArguments) {
            this.objectId = objectId;
            this.methodId = methodId;
            this.noOfInputArguments = noOfInputArguments;
            this.inputArguments = inputArguments;
        }

        @Override
        public CallMethodRequest build() {
            CallMethodRequest callMethodRequest = new CallMethodRequest(this.objectId, this.methodId, this.noOfInputArguments, this.inputArguments);
            return callMethodRequest;
        }
    }
}

