/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.TimestampsToReturn;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class CreateMonitoredItemsRequest
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition requestHeader;
    protected final long subscriptionId;
    protected final TimestampsToReturn timestampsToReturn;
    protected final int noOfItemsToCreate;
    protected final List<ExtensionObjectDefinition> itemsToCreate;

    @Override
    public String getIdentifier() {
        return "751";
    }

    public CreateMonitoredItemsRequest(ExtensionObjectDefinition requestHeader, long subscriptionId, TimestampsToReturn timestampsToReturn, int noOfItemsToCreate, List<ExtensionObjectDefinition> itemsToCreate) {
        this.requestHeader = requestHeader;
        this.subscriptionId = subscriptionId;
        this.timestampsToReturn = timestampsToReturn;
        this.noOfItemsToCreate = noOfItemsToCreate;
        this.itemsToCreate = itemsToCreate;
    }

    public ExtensionObjectDefinition getRequestHeader() {
        return this.requestHeader;
    }

    public long getSubscriptionId() {
        return this.subscriptionId;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.timestampsToReturn;
    }

    public int getNoOfItemsToCreate() {
        return this.noOfItemsToCreate;
    }

    public List<ExtensionObjectDefinition> getItemsToCreate() {
        return this.itemsToCreate;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CreateMonitoredItemsRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("requestHeader", this.requestHeader, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("subscriptionId", this.subscriptionId, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField("timestampsToReturn", "TimestampsToReturn", this.timestampsToReturn, new DataWriterEnumDefault<TimestampsToReturn, Long>(TimestampsToReturn::getValue, Enum::name, DataWriterFactory.writeUnsignedLong(writeBuffer, 32)), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfItemsToCreate", this.noOfItemsToCreate, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("itemsToCreate", this.itemsToCreate, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("CreateMonitoredItemsRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        CreateMonitoredItemsRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.itemsToCreate != null) {
            int i = 0;
            for (ExtensionObjectDefinition element : this.itemsToCreate) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.itemsToCreate.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("CreateMonitoredItemsRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObjectDefinition requestHeader = FieldReaderFactory.readSimpleField("requestHeader", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "391"), readBuffer), new WithReaderArgs[0]);
        long subscriptionId = FieldReaderFactory.readSimpleField("subscriptionId", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        TimestampsToReturn timestampsToReturn = (TimestampsToReturn)((Object)FieldReaderFactory.readEnumField("timestampsToReturn", "TimestampsToReturn", new DataReaderEnumDefault<TimestampsToReturn, Long>(TimestampsToReturn::enumForValue, DataReaderFactory.readUnsignedLong(readBuffer, 32)), new WithReaderArgs[0]));
        int noOfItemsToCreate = FieldReaderFactory.readSimpleField("noOfItemsToCreate", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<ExtensionObjectDefinition> itemsToCreate = FieldReaderFactory.readCountArrayField("itemsToCreate", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "745"), readBuffer), noOfItemsToCreate, new WithReaderArgs[0]);
        readBuffer.closeContext("CreateMonitoredItemsRequest", new WithReaderArgs[0]);
        return new CreateMonitoredItemsRequestBuilderImpl(requestHeader, subscriptionId, timestampsToReturn, noOfItemsToCreate, itemsToCreate);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateMonitoredItemsRequest)) {
            return false;
        }
        CreateMonitoredItemsRequest that = (CreateMonitoredItemsRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getSubscriptionId() == that.getSubscriptionId() && this.getTimestampsToReturn() == that.getTimestampsToReturn() && this.getNoOfItemsToCreate() == that.getNoOfItemsToCreate() && this.getItemsToCreate() == that.getItemsToCreate() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getRequestHeader(), this.getSubscriptionId(), this.getTimestampsToReturn(), this.getNoOfItemsToCreate(), this.getItemsToCreate()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CreateMonitoredItemsRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition requestHeader;
        private final long subscriptionId;
        private final TimestampsToReturn timestampsToReturn;
        private final int noOfItemsToCreate;
        private final List<ExtensionObjectDefinition> itemsToCreate;

        public CreateMonitoredItemsRequestBuilderImpl(ExtensionObjectDefinition requestHeader, long subscriptionId, TimestampsToReturn timestampsToReturn, int noOfItemsToCreate, List<ExtensionObjectDefinition> itemsToCreate) {
            this.requestHeader = requestHeader;
            this.subscriptionId = subscriptionId;
            this.timestampsToReturn = timestampsToReturn;
            this.noOfItemsToCreate = noOfItemsToCreate;
            this.itemsToCreate = itemsToCreate;
        }

        @Override
        public CreateMonitoredItemsRequest build() {
            CreateMonitoredItemsRequest createMonitoredItemsRequest = new CreateMonitoredItemsRequest(this.requestHeader, this.subscriptionId, this.timestampsToReturn, this.noOfItemsToCreate, this.itemsToCreate);
            return createMonitoredItemsRequest;
        }
    }
}

