/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DataTypeDescription;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class DataTypeSchemaHeader
extends ExtensionObjectDefinition
implements Message {
    protected final int noOfNamespaces;
    protected final List<PascalString> namespaces;
    protected final int noOfStructureDataTypes;
    protected final List<DataTypeDescription> structureDataTypes;
    protected final int noOfEnumDataTypes;
    protected final List<DataTypeDescription> enumDataTypes;
    protected final int noOfSimpleDataTypes;
    protected final List<DataTypeDescription> simpleDataTypes;

    @Override
    public String getIdentifier() {
        return "15536";
    }

    public DataTypeSchemaHeader(int noOfNamespaces, List<PascalString> namespaces, int noOfStructureDataTypes, List<DataTypeDescription> structureDataTypes, int noOfEnumDataTypes, List<DataTypeDescription> enumDataTypes, int noOfSimpleDataTypes, List<DataTypeDescription> simpleDataTypes) {
        this.noOfNamespaces = noOfNamespaces;
        this.namespaces = namespaces;
        this.noOfStructureDataTypes = noOfStructureDataTypes;
        this.structureDataTypes = structureDataTypes;
        this.noOfEnumDataTypes = noOfEnumDataTypes;
        this.enumDataTypes = enumDataTypes;
        this.noOfSimpleDataTypes = noOfSimpleDataTypes;
        this.simpleDataTypes = simpleDataTypes;
    }

    public int getNoOfNamespaces() {
        return this.noOfNamespaces;
    }

    public List<PascalString> getNamespaces() {
        return this.namespaces;
    }

    public int getNoOfStructureDataTypes() {
        return this.noOfStructureDataTypes;
    }

    public List<DataTypeDescription> getStructureDataTypes() {
        return this.structureDataTypes;
    }

    public int getNoOfEnumDataTypes() {
        return this.noOfEnumDataTypes;
    }

    public List<DataTypeDescription> getEnumDataTypes() {
        return this.enumDataTypes;
    }

    public int getNoOfSimpleDataTypes() {
        return this.noOfSimpleDataTypes;
    }

    public List<DataTypeDescription> getSimpleDataTypes() {
        return this.simpleDataTypes;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("DataTypeSchemaHeader", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfNamespaces", this.noOfNamespaces, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("namespaces", this.namespaces, writeBuffer, new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfStructureDataTypes", this.noOfStructureDataTypes, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("structureDataTypes", this.structureDataTypes, writeBuffer, new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfEnumDataTypes", this.noOfEnumDataTypes, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("enumDataTypes", this.enumDataTypes, writeBuffer, new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfSimpleDataTypes", this.noOfSimpleDataTypes, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("simpleDataTypes", this.simpleDataTypes, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("DataTypeSchemaHeader", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        DataTypeSchemaHeader _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        if (this.namespaces != null) {
            i = 0;
            for (PascalString pascalString : this.namespaces) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.namespaces.size());
                lengthInBits += pascalString.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.structureDataTypes != null) {
            i = 0;
            for (DataTypeDescription dataTypeDescription : this.structureDataTypes) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.structureDataTypes.size());
                lengthInBits += dataTypeDescription.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.enumDataTypes != null) {
            i = 0;
            for (DataTypeDescription dataTypeDescription : this.enumDataTypes) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.enumDataTypes.size());
                lengthInBits += dataTypeDescription.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.simpleDataTypes != null) {
            i = 0;
            for (DataTypeDescription dataTypeDescription : this.simpleDataTypes) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.simpleDataTypes.size());
                lengthInBits += dataTypeDescription.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("DataTypeSchemaHeader", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int noOfNamespaces = FieldReaderFactory.readSimpleField("noOfNamespaces", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<PascalString> namespaces = FieldReaderFactory.readCountArrayField("namespaces", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), noOfNamespaces, new WithReaderArgs[0]);
        int noOfStructureDataTypes = FieldReaderFactory.readSimpleField("noOfStructureDataTypes", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<DataTypeDescription> structureDataTypes = FieldReaderFactory.readCountArrayField("structureDataTypes", new DataReaderComplexDefault<DataTypeDescription>(() -> (DataTypeDescription)ExtensionObjectDefinition.staticParse(readBuffer, "14525"), readBuffer), noOfStructureDataTypes, new WithReaderArgs[0]);
        int noOfEnumDataTypes = FieldReaderFactory.readSimpleField("noOfEnumDataTypes", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<DataTypeDescription> enumDataTypes = FieldReaderFactory.readCountArrayField("enumDataTypes", new DataReaderComplexDefault<DataTypeDescription>(() -> (DataTypeDescription)ExtensionObjectDefinition.staticParse(readBuffer, "14525"), readBuffer), noOfEnumDataTypes, new WithReaderArgs[0]);
        int noOfSimpleDataTypes = FieldReaderFactory.readSimpleField("noOfSimpleDataTypes", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<DataTypeDescription> simpleDataTypes = FieldReaderFactory.readCountArrayField("simpleDataTypes", new DataReaderComplexDefault<DataTypeDescription>(() -> (DataTypeDescription)ExtensionObjectDefinition.staticParse(readBuffer, "14525"), readBuffer), noOfSimpleDataTypes, new WithReaderArgs[0]);
        readBuffer.closeContext("DataTypeSchemaHeader", new WithReaderArgs[0]);
        return new DataTypeSchemaHeaderBuilderImpl(noOfNamespaces, namespaces, noOfStructureDataTypes, structureDataTypes, noOfEnumDataTypes, enumDataTypes, noOfSimpleDataTypes, simpleDataTypes);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataTypeSchemaHeader)) {
            return false;
        }
        DataTypeSchemaHeader that = (DataTypeSchemaHeader)o;
        return this.getNoOfNamespaces() == that.getNoOfNamespaces() && this.getNamespaces() == that.getNamespaces() && this.getNoOfStructureDataTypes() == that.getNoOfStructureDataTypes() && this.getStructureDataTypes() == that.getStructureDataTypes() && this.getNoOfEnumDataTypes() == that.getNoOfEnumDataTypes() && this.getEnumDataTypes() == that.getEnumDataTypes() && this.getNoOfSimpleDataTypes() == that.getNoOfSimpleDataTypes() && this.getSimpleDataTypes() == that.getSimpleDataTypes() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNoOfNamespaces(), this.getNamespaces(), this.getNoOfStructureDataTypes(), this.getStructureDataTypes(), this.getNoOfEnumDataTypes(), this.getEnumDataTypes(), this.getNoOfSimpleDataTypes(), this.getSimpleDataTypes());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class DataTypeSchemaHeaderBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final int noOfNamespaces;
        private final List<PascalString> namespaces;
        private final int noOfStructureDataTypes;
        private final List<DataTypeDescription> structureDataTypes;
        private final int noOfEnumDataTypes;
        private final List<DataTypeDescription> enumDataTypes;
        private final int noOfSimpleDataTypes;
        private final List<DataTypeDescription> simpleDataTypes;

        public DataTypeSchemaHeaderBuilderImpl(int noOfNamespaces, List<PascalString> namespaces, int noOfStructureDataTypes, List<DataTypeDescription> structureDataTypes, int noOfEnumDataTypes, List<DataTypeDescription> enumDataTypes, int noOfSimpleDataTypes, List<DataTypeDescription> simpleDataTypes) {
            this.noOfNamespaces = noOfNamespaces;
            this.namespaces = namespaces;
            this.noOfStructureDataTypes = noOfStructureDataTypes;
            this.structureDataTypes = structureDataTypes;
            this.noOfEnumDataTypes = noOfEnumDataTypes;
            this.enumDataTypes = enumDataTypes;
            this.noOfSimpleDataTypes = noOfSimpleDataTypes;
            this.simpleDataTypes = simpleDataTypes;
        }

        @Override
        public DataTypeSchemaHeader build() {
            DataTypeSchemaHeader dataTypeSchemaHeader = new DataTypeSchemaHeader(this.noOfNamespaces, this.namespaces, this.noOfStructureDataTypes, this.structureDataTypes, this.noOfEnumDataTypes, this.enumDataTypes, this.noOfSimpleDataTypes, this.simpleDataTypes);
            return dataTypeSchemaHeader;
        }
    }
}

