/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.Payload;
import org.apache.plc4x.java.opcua.readwrite.SequenceHeader;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class ExtensiblePayload
extends Payload
implements Message {
    protected final ExtensionObject payload;

    @Override
    public Boolean getExtensible() {
        return true;
    }

    public ExtensiblePayload(SequenceHeader sequenceHeader, ExtensionObject payload) {
        super(sequenceHeader);
        this.payload = payload;
    }

    public ExtensionObject getPayload() {
        return this.payload;
    }

    @Override
    protected void serializePayloadChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ExtensiblePayload", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("payload", this.payload, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("ExtensiblePayload", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ExtensiblePayload _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits += this.payload.getLengthInBits();
    }

    public static Payload.PayloadBuilder staticParsePayloadBuilder(ReadBuffer readBuffer, Boolean extensible, Long byteCount) throws ParseException {
        readBuffer.pullContext("ExtensiblePayload", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObject payload = FieldReaderFactory.readSimpleField("payload", new DataReaderComplexDefault<ExtensionObject>(() -> ExtensionObject.staticParse(readBuffer, false), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("ExtensiblePayload", new WithReaderArgs[0]);
        return new ExtensiblePayloadBuilderImpl(payload);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtensiblePayload)) {
            return false;
        }
        ExtensiblePayload that = (ExtensiblePayload)o;
        return this.getPayload() == that.getPayload() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getPayload());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ExtensiblePayloadBuilderImpl
    implements Payload.PayloadBuilder {
        private final ExtensionObject payload;

        public ExtensiblePayloadBuilderImpl(ExtensionObject payload) {
            this.payload = payload;
        }

        @Override
        public ExtensiblePayload build(SequenceHeader sequenceHeader) {
            ExtensiblePayload extensiblePayload = new ExtensiblePayload(sequenceHeader, this.payload);
            return extensiblePayload;
        }
    }
}

