/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.opcua.readwrite.ExpandedNodeId;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectEncodingMask;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class ExtensionObject
implements Message {
    protected final ExpandedNodeId typeId;
    protected final ExtensionObjectEncodingMask encodingMask;
    protected final ExtensionObjectDefinition body;

    public ExtensionObject(ExpandedNodeId typeId, ExtensionObjectEncodingMask encodingMask, ExtensionObjectDefinition body) {
        this.typeId = typeId;
        this.encodingMask = encodingMask;
        this.body = body;
    }

    public ExpandedNodeId getTypeId() {
        return this.typeId;
    }

    public ExtensionObjectEncodingMask getEncodingMask() {
        return this.encodingMask;
    }

    public ExtensionObjectDefinition getBody() {
        return this.body;
    }

    public String getIdentifier() {
        return String.valueOf(this.getTypeId().getIdentifier());
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ExtensionObject", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("typeId", this.typeId, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField("encodingMask", this.encodingMask, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        String identifier = this.getIdentifier();
        writeBuffer.writeVirtual("identifier", identifier, new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("body", this.body, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("ExtensionObject", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        ExtensionObject _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.typeId.getLengthInBits();
        if (this.encodingMask != null) {
            lengthInBits += this.encodingMask.getLengthInBits();
        }
        return lengthInBits += this.body.getLengthInBits();
    }

    public static ExtensionObject staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Boolean includeEncodingMask;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Boolean) {
            includeEncodingMask = (Boolean)args[0];
        } else if (args[0] instanceof String) {
            includeEncodingMask = Boolean.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Boolean or a string which is parseable but was " + args[0].getClass().getName());
        }
        return ExtensionObject.staticParse(readBuffer, includeEncodingMask);
    }

    public static ExtensionObject staticParse(ReadBuffer readBuffer, Boolean includeEncodingMask) throws ParseException {
        readBuffer.pullContext("ExtensionObject", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ExpandedNodeId typeId = FieldReaderFactory.readSimpleField("typeId", new DataReaderComplexDefault<ExpandedNodeId>(() -> ExpandedNodeId.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        ExtensionObjectEncodingMask encodingMask = FieldReaderFactory.readOptionalField("encodingMask", new DataReaderComplexDefault<ExtensionObjectEncodingMask>(() -> ExtensionObjectEncodingMask.staticParse(readBuffer), readBuffer), includeEncodingMask, new WithReaderArgs[0]);
        String identifier = FieldReaderFactory.readVirtualField("identifier", String.class, typeId.getIdentifier(), new WithReaderArgs[0]);
        ExtensionObjectDefinition body = FieldReaderFactory.readSimpleField("body", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, identifier), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("ExtensionObject", new WithReaderArgs[0]);
        ExtensionObject _extensionObject = new ExtensionObject(typeId, encodingMask, body);
        return _extensionObject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtensionObject)) {
            return false;
        }
        ExtensionObject that = (ExtensionObject)o;
        return this.getTypeId() == that.getTypeId() && this.getEncodingMask() == that.getEncodingMask() && this.getBody() == that.getBody();
    }

    public int hashCode() {
        return Objects.hash(this.getTypeId(), this.getEncodingMask(), this.getBody());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

