/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DataValue;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class HistoryData
extends ExtensionObjectDefinition
implements Message {
    protected final int noOfDataValues;
    protected final List<DataValue> dataValues;

    @Override
    public String getIdentifier() {
        return "658";
    }

    public HistoryData(int noOfDataValues, List<DataValue> dataValues) {
        this.noOfDataValues = noOfDataValues;
        this.dataValues = dataValues;
    }

    public int getNoOfDataValues() {
        return this.noOfDataValues;
    }

    public List<DataValue> getDataValues() {
        return this.dataValues;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("HistoryData", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfDataValues", this.noOfDataValues, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("dataValues", this.dataValues, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("HistoryData", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        HistoryData _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        if (this.dataValues != null) {
            int i = 0;
            for (DataValue element : this.dataValues) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.dataValues.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("HistoryData", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int noOfDataValues = FieldReaderFactory.readSimpleField("noOfDataValues", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<DataValue> dataValues = FieldReaderFactory.readCountArrayField("dataValues", new DataReaderComplexDefault<DataValue>(() -> DataValue.staticParse(readBuffer), readBuffer), noOfDataValues, new WithReaderArgs[0]);
        readBuffer.closeContext("HistoryData", new WithReaderArgs[0]);
        return new HistoryDataBuilderImpl(noOfDataValues, dataValues);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HistoryData)) {
            return false;
        }
        HistoryData that = (HistoryData)o;
        return this.getNoOfDataValues() == that.getNoOfDataValues() && this.getDataValues() == that.getDataValues() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNoOfDataValues(), this.getDataValues());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class HistoryDataBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final int noOfDataValues;
        private final List<DataValue> dataValues;

        public HistoryDataBuilderImpl(int noOfDataValues, List<DataValue> dataValues) {
            this.noOfDataValues = noOfDataValues;
            this.dataValues = dataValues;
        }

        @Override
        public HistoryData build() {
            HistoryData historyData = new HistoryData(this.noOfDataValues, this.dataValues);
            return historyData;
        }
    }
}

