/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.Variant;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class HistoryEventFieldList
extends ExtensionObjectDefinition
implements Message {
    protected final int noOfEventFields;
    protected final List<Variant> eventFields;

    @Override
    public String getIdentifier() {
        return "922";
    }

    public HistoryEventFieldList(int noOfEventFields, List<Variant> eventFields) {
        this.noOfEventFields = noOfEventFields;
        this.eventFields = eventFields;
    }

    public int getNoOfEventFields() {
        return this.noOfEventFields;
    }

    public List<Variant> getEventFields() {
        return this.eventFields;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("HistoryEventFieldList", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfEventFields", this.noOfEventFields, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("eventFields", this.eventFields, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("HistoryEventFieldList", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        HistoryEventFieldList _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        if (this.eventFields != null) {
            int i = 0;
            for (Variant element : this.eventFields) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.eventFields.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("HistoryEventFieldList", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int noOfEventFields = FieldReaderFactory.readSimpleField("noOfEventFields", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<Variant> eventFields = FieldReaderFactory.readCountArrayField("eventFields", new DataReaderComplexDefault<Variant>(() -> Variant.staticParse(readBuffer), readBuffer), noOfEventFields, new WithReaderArgs[0]);
        readBuffer.closeContext("HistoryEventFieldList", new WithReaderArgs[0]);
        return new HistoryEventFieldListBuilderImpl(noOfEventFields, eventFields);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HistoryEventFieldList)) {
            return false;
        }
        HistoryEventFieldList that = (HistoryEventFieldList)o;
        return this.getNoOfEventFields() == that.getNoOfEventFields() && this.getEventFields() == that.getEventFields() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNoOfEventFields(), this.getEventFields());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class HistoryEventFieldListBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final int noOfEventFields;
        private final List<Variant> eventFields;

        public HistoryEventFieldListBuilderImpl(int noOfEventFields, List<Variant> eventFields) {
            this.noOfEventFields = noOfEventFields;
            this.eventFields = eventFields;
        }

        @Override
        public HistoryEventFieldList build() {
            HistoryEventFieldList historyEventFieldList = new HistoryEventFieldList(this.noOfEventFields, this.eventFields);
            return historyEventFieldList;
        }
    }
}

