/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class HistoryUpdateRequest
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition requestHeader;
    protected final int noOfHistoryUpdateDetails;
    protected final List<ExtensionObject> historyUpdateDetails;

    @Override
    public String getIdentifier() {
        return "700";
    }

    public HistoryUpdateRequest(ExtensionObjectDefinition requestHeader, int noOfHistoryUpdateDetails, List<ExtensionObject> historyUpdateDetails) {
        this.requestHeader = requestHeader;
        this.noOfHistoryUpdateDetails = noOfHistoryUpdateDetails;
        this.historyUpdateDetails = historyUpdateDetails;
    }

    public ExtensionObjectDefinition getRequestHeader() {
        return this.requestHeader;
    }

    public int getNoOfHistoryUpdateDetails() {
        return this.noOfHistoryUpdateDetails;
    }

    public List<ExtensionObject> getHistoryUpdateDetails() {
        return this.historyUpdateDetails;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("HistoryUpdateRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("requestHeader", this.requestHeader, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfHistoryUpdateDetails", this.noOfHistoryUpdateDetails, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("historyUpdateDetails", this.historyUpdateDetails, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("HistoryUpdateRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        HistoryUpdateRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.historyUpdateDetails != null) {
            int i = 0;
            for (ExtensionObject element : this.historyUpdateDetails) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.historyUpdateDetails.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("HistoryUpdateRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObjectDefinition requestHeader = FieldReaderFactory.readSimpleField("requestHeader", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "391"), readBuffer), new WithReaderArgs[0]);
        int noOfHistoryUpdateDetails = FieldReaderFactory.readSimpleField("noOfHistoryUpdateDetails", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<ExtensionObject> historyUpdateDetails = FieldReaderFactory.readCountArrayField("historyUpdateDetails", new DataReaderComplexDefault<ExtensionObject>(() -> ExtensionObject.staticParse(readBuffer, true), readBuffer), noOfHistoryUpdateDetails, new WithReaderArgs[0]);
        readBuffer.closeContext("HistoryUpdateRequest", new WithReaderArgs[0]);
        return new HistoryUpdateRequestBuilderImpl(requestHeader, noOfHistoryUpdateDetails, historyUpdateDetails);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HistoryUpdateRequest)) {
            return false;
        }
        HistoryUpdateRequest that = (HistoryUpdateRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getNoOfHistoryUpdateDetails() == that.getNoOfHistoryUpdateDetails() && this.getHistoryUpdateDetails() == that.getHistoryUpdateDetails() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getNoOfHistoryUpdateDetails(), this.getHistoryUpdateDetails());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class HistoryUpdateRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition requestHeader;
        private final int noOfHistoryUpdateDetails;
        private final List<ExtensionObject> historyUpdateDetails;

        public HistoryUpdateRequestBuilderImpl(ExtensionObjectDefinition requestHeader, int noOfHistoryUpdateDetails, List<ExtensionObject> historyUpdateDetails) {
            this.requestHeader = requestHeader;
            this.noOfHistoryUpdateDetails = noOfHistoryUpdateDetails;
            this.historyUpdateDetails = historyUpdateDetails;
        }

        @Override
        public HistoryUpdateRequest build() {
            HistoryUpdateRequest historyUpdateRequest = new HistoryUpdateRequest(this.requestHeader, this.noOfHistoryUpdateDetails, this.historyUpdateDetails);
            return historyUpdateRequest;
        }
    }
}

