/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.opcua.readwrite.UserIdentityTokenDefinition;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class IssuedIdentityToken
extends UserIdentityTokenDefinition
implements Message {
    protected final PascalByteString tokenData;
    protected final PascalString encryptionAlgorithm;

    @Override
    public String getIdentifier() {
        return "identity";
    }

    public IssuedIdentityToken(PascalByteString tokenData, PascalString encryptionAlgorithm) {
        this.tokenData = tokenData;
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    public PascalByteString getTokenData() {
        return this.tokenData;
    }

    public PascalString getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @Override
    protected void serializeUserIdentityTokenDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("IssuedIdentityToken", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("tokenData", this.tokenData, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("encryptionAlgorithm", this.encryptionAlgorithm, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("IssuedIdentityToken", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        IssuedIdentityToken _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.tokenData.getLengthInBits();
        return lengthInBits += this.encryptionAlgorithm.getLengthInBits();
    }

    public static UserIdentityTokenDefinition.UserIdentityTokenDefinitionBuilder staticParseUserIdentityTokenDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("IssuedIdentityToken", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        PascalByteString tokenData = FieldReaderFactory.readSimpleField("tokenData", new DataReaderComplexDefault<PascalByteString>(() -> PascalByteString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        PascalString encryptionAlgorithm = FieldReaderFactory.readSimpleField("encryptionAlgorithm", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("IssuedIdentityToken", new WithReaderArgs[0]);
        return new IssuedIdentityTokenBuilderImpl(tokenData, encryptionAlgorithm);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IssuedIdentityToken)) {
            return false;
        }
        IssuedIdentityToken that = (IssuedIdentityToken)o;
        return this.getTokenData() == that.getTokenData() && this.getEncryptionAlgorithm() == that.getEncryptionAlgorithm() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTokenData(), this.getEncryptionAlgorithm());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class IssuedIdentityTokenBuilderImpl
    implements UserIdentityTokenDefinition.UserIdentityTokenDefinitionBuilder {
        private final PascalByteString tokenData;
        private final PascalString encryptionAlgorithm;

        public IssuedIdentityTokenBuilderImpl(PascalByteString tokenData, PascalString encryptionAlgorithm) {
            this.tokenData = tokenData;
            this.encryptionAlgorithm = encryptionAlgorithm;
        }

        @Override
        public IssuedIdentityToken build() {
            IssuedIdentityToken issuedIdentityToken = new IssuedIdentityToken(this.tokenData, this.encryptionAlgorithm);
            return issuedIdentityToken;
        }
    }
}

