/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.opcua.readwrite.ChunkType;
import org.apache.plc4x.java.opcua.readwrite.OpcuaAcknowledgeResponse;
import org.apache.plc4x.java.opcua.readwrite.OpcuaCloseRequest;
import org.apache.plc4x.java.opcua.readwrite.OpcuaHelloRequest;
import org.apache.plc4x.java.opcua.readwrite.OpcuaMessageError;
import org.apache.plc4x.java.opcua.readwrite.OpcuaMessageRequest;
import org.apache.plc4x.java.opcua.readwrite.OpcuaMessageResponse;
import org.apache.plc4x.java.opcua.readwrite.OpcuaOpenRequest;
import org.apache.plc4x.java.opcua.readwrite.OpcuaOpenResponse;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public abstract class MessagePDU
implements Message {
    protected final ChunkType chunk;

    public abstract String getMessageType();

    public abstract Boolean getResponse();

    public MessagePDU(ChunkType chunk) {
        this.chunk = chunk;
    }

    public ChunkType getChunk() {
        return this.chunk;
    }

    protected abstract void serializeMessagePDUChild(WriteBuffer var1) throws SerializationException;

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("MessagePDU", new WithWriterArgs[0]);
        FieldWriterFactory.writeDiscriminatorField("messageType", this.getMessageType(), DataWriterFactory.writeString(writeBuffer, 24), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField("chunk", "ChunkType", this.chunk, new DataWriterEnumDefault<ChunkType, String>(ChunkType::getValue, Enum::name, DataWriterFactory.writeString(writeBuffer, 8)), new WithWriterArgs[0]);
        long totalLength = this.getLengthInBytes();
        FieldWriterFactory.writeImplicitField("totalLength", totalLength, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        this.serializeMessagePDUChild(writeBuffer);
        writeBuffer.popContext("MessagePDU", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        MessagePDU _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 24;
        lengthInBits += 8;
        return lengthInBits += 32;
    }

    public static MessagePDU staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Boolean response;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 1) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 1, but got " + args.length);
        }
        if (args[0] instanceof Boolean) {
            response = (Boolean)args[0];
        } else if (args[0] instanceof String) {
            response = Boolean.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Boolean or a string which is parseable but was " + args[0].getClass().getName());
        }
        return MessagePDU.staticParse(readBuffer, response);
    }

    public static MessagePDU staticParse(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("MessagePDU", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        String messageType = FieldReaderFactory.readDiscriminatorField("messageType", DataReaderFactory.readString(readBuffer, 24), new WithReaderArgs[0]);
        ChunkType chunk = (ChunkType)((Object)FieldReaderFactory.readEnumField("chunk", "ChunkType", new DataReaderEnumDefault<ChunkType, String>(ChunkType::enumForValue, DataReaderFactory.readString(readBuffer, 8)), new WithReaderArgs[0]));
        long totalLength = FieldReaderFactory.readImplicitField("totalLength", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        MessagePDUBuilder builder = null;
        if (EvaluationHelper.equals(messageType, "HEL") && EvaluationHelper.equals(response, false)) {
            builder = OpcuaHelloRequest.staticParseMessagePDUBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals(messageType, "ACK") && EvaluationHelper.equals(response, true)) {
            builder = OpcuaAcknowledgeResponse.staticParseMessagePDUBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals(messageType, "OPN") && EvaluationHelper.equals(response, false)) {
            builder = OpcuaOpenRequest.staticParseMessagePDUBuilder(readBuffer, totalLength, response);
        } else if (EvaluationHelper.equals(messageType, "OPN") && EvaluationHelper.equals(response, true)) {
            builder = OpcuaOpenResponse.staticParseMessagePDUBuilder(readBuffer, totalLength, response);
        } else if (EvaluationHelper.equals(messageType, "CLO") && EvaluationHelper.equals(response, false)) {
            builder = OpcuaCloseRequest.staticParseMessagePDUBuilder(readBuffer, response);
        } else if (EvaluationHelper.equals(messageType, "MSG") && EvaluationHelper.equals(response, false)) {
            builder = OpcuaMessageRequest.staticParseMessagePDUBuilder(readBuffer, totalLength, response);
        } else if (EvaluationHelper.equals(messageType, "MSG") && EvaluationHelper.equals(response, true)) {
            builder = OpcuaMessageResponse.staticParseMessagePDUBuilder(readBuffer, totalLength, response);
        } else if (EvaluationHelper.equals(messageType, "ERR") && EvaluationHelper.equals(response, true)) {
            builder = OpcuaMessageError.staticParseMessagePDUBuilder(readBuffer, response);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [messageType=" + messageType + " " + "response=" + response + "]");
        }
        readBuffer.closeContext("MessagePDU", new WithReaderArgs[0]);
        MessagePDU _messagePDU = builder.build(chunk);
        return _messagePDU;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MessagePDU)) {
            return false;
        }
        MessagePDU that = (MessagePDU)o;
        return this.getChunk() == that.getChunk();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getChunk()});
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface MessagePDUBuilder {
        public MessagePDU build(ChunkType var1);
    }
}

