/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class NodeReference
extends ExtensionObjectDefinition
implements Message {
    protected final NodeId nodeId;
    protected final NodeId referenceTypeId;
    protected final boolean isForward;
    protected final int noOfReferencedNodeIds;
    protected final List<NodeId> referencedNodeIds;

    @Override
    public String getIdentifier() {
        return "582";
    }

    public NodeReference(NodeId nodeId, NodeId referenceTypeId, boolean isForward, int noOfReferencedNodeIds, List<NodeId> referencedNodeIds) {
        this.nodeId = nodeId;
        this.referenceTypeId = referenceTypeId;
        this.isForward = isForward;
        this.noOfReferencedNodeIds = noOfReferencedNodeIds;
        this.referencedNodeIds = referencedNodeIds;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public NodeId getReferenceTypeId() {
        return this.referenceTypeId;
    }

    public boolean getIsForward() {
        return this.isForward;
    }

    public int getNoOfReferencedNodeIds() {
        return this.noOfReferencedNodeIds;
    }

    public List<NodeId> getReferencedNodeIds() {
        return this.referencedNodeIds;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("NodeReference", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("nodeId", this.nodeId, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("referenceTypeId", this.referenceTypeId, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField("reserved", (byte)0, DataWriterFactory.writeUnsignedByte(writeBuffer, 7), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("isForward", this.isForward, DataWriterFactory.writeBoolean(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfReferencedNodeIds", this.noOfReferencedNodeIds, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("referencedNodeIds", this.referencedNodeIds, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("NodeReference", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        NodeReference _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.nodeId.getLengthInBits();
        lengthInBits += this.referenceTypeId.getLengthInBits();
        lengthInBits += 7;
        ++lengthInBits;
        lengthInBits += 32;
        if (this.referencedNodeIds != null) {
            int i = 0;
            for (NodeId element : this.referencedNodeIds) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.referencedNodeIds.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("NodeReference", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        NodeId nodeId = FieldReaderFactory.readSimpleField("nodeId", new DataReaderComplexDefault<NodeId>(() -> NodeId.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        NodeId referenceTypeId = FieldReaderFactory.readSimpleField("referenceTypeId", new DataReaderComplexDefault<NodeId>(() -> NodeId.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        Byte reservedField0 = FieldReaderFactory.readReservedField("reserved", DataReaderFactory.readUnsignedByte(readBuffer, 7), (byte)0, new WithReaderArgs[0]);
        boolean isForward = FieldReaderFactory.readSimpleField("isForward", DataReaderFactory.readBoolean(readBuffer), new WithReaderArgs[0]);
        int noOfReferencedNodeIds = FieldReaderFactory.readSimpleField("noOfReferencedNodeIds", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<NodeId> referencedNodeIds = FieldReaderFactory.readCountArrayField("referencedNodeIds", new DataReaderComplexDefault<NodeId>(() -> NodeId.staticParse(readBuffer), readBuffer), noOfReferencedNodeIds, new WithReaderArgs[0]);
        readBuffer.closeContext("NodeReference", new WithReaderArgs[0]);
        return new NodeReferenceBuilderImpl(nodeId, referenceTypeId, isForward, noOfReferencedNodeIds, referencedNodeIds);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeReference)) {
            return false;
        }
        NodeReference that = (NodeReference)o;
        return this.getNodeId() == that.getNodeId() && this.getReferenceTypeId() == that.getReferenceTypeId() && this.getIsForward() == that.getIsForward() && this.getNoOfReferencedNodeIds() == that.getNoOfReferencedNodeIds() && this.getReferencedNodeIds() == that.getReferencedNodeIds() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNodeId(), this.getReferenceTypeId(), this.getIsForward(), this.getNoOfReferencedNodeIds(), this.getReferencedNodeIds());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class NodeReferenceBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final NodeId nodeId;
        private final NodeId referenceTypeId;
        private final boolean isForward;
        private final int noOfReferencedNodeIds;
        private final List<NodeId> referencedNodeIds;

        public NodeReferenceBuilderImpl(NodeId nodeId, NodeId referenceTypeId, boolean isForward, int noOfReferencedNodeIds, List<NodeId> referencedNodeIds) {
            this.nodeId = nodeId;
            this.referenceTypeId = referenceTypeId;
            this.isForward = isForward;
            this.noOfReferencedNodeIds = noOfReferencedNodeIds;
            this.referencedNodeIds = referencedNodeIds;
        }

        @Override
        public NodeReference build() {
            NodeReference nodeReference = new NodeReference(this.nodeId, this.referenceTypeId, this.isForward, this.noOfReferencedNodeIds, this.referencedNodeIds);
            return nodeReference;
        }
    }
}

