/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ChunkType;
import org.apache.plc4x.java.opcua.readwrite.MessagePDU;
import org.apache.plc4x.java.opcua.readwrite.OpcuaProtocolLimits;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class OpcuaAcknowledgeResponse
extends MessagePDU
implements Message {
    protected final long version;
    protected final OpcuaProtocolLimits limits;

    @Override
    public String getMessageType() {
        return "ACK";
    }

    @Override
    public Boolean getResponse() {
        return true;
    }

    public OpcuaAcknowledgeResponse(ChunkType chunk, long version, OpcuaProtocolLimits limits) {
        super(chunk);
        this.version = version;
        this.limits = limits;
    }

    public long getVersion() {
        return this.version;
    }

    public OpcuaProtocolLimits getLimits() {
        return this.limits;
    }

    @Override
    protected void serializeMessagePDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("OpcuaAcknowledgeResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("version", this.version, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("limits", this.limits, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("OpcuaAcknowledgeResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        OpcuaAcknowledgeResponse _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        return lengthInBits += this.limits.getLengthInBits();
    }

    public static MessagePDU.MessagePDUBuilder staticParseMessagePDUBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("OpcuaAcknowledgeResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        long version = FieldReaderFactory.readSimpleField("version", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        OpcuaProtocolLimits limits = FieldReaderFactory.readSimpleField("limits", new DataReaderComplexDefault<OpcuaProtocolLimits>(() -> OpcuaProtocolLimits.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("OpcuaAcknowledgeResponse", new WithReaderArgs[0]);
        return new OpcuaAcknowledgeResponseBuilderImpl(version, limits);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpcuaAcknowledgeResponse)) {
            return false;
        }
        OpcuaAcknowledgeResponse that = (OpcuaAcknowledgeResponse)o;
        return this.getVersion() == that.getVersion() && this.getLimits() == that.getLimits() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getVersion(), this.getLimits());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class OpcuaAcknowledgeResponseBuilderImpl
    implements MessagePDU.MessagePDUBuilder {
        private final long version;
        private final OpcuaProtocolLimits limits;

        public OpcuaAcknowledgeResponseBuilderImpl(long version, OpcuaProtocolLimits limits) {
            this.version = version;
            this.limits = limits;
        }

        @Override
        public OpcuaAcknowledgeResponse build(ChunkType chunk) {
            OpcuaAcknowledgeResponse opcuaAcknowledgeResponse = new OpcuaAcknowledgeResponse(chunk, this.version, this.limits);
            return opcuaAcknowledgeResponse;
        }
    }
}

