/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.OpenChannelMessage;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class OpenChannelMessageRequest
extends OpenChannelMessage
implements Message {
    protected final int secureChannelId;
    protected final PascalString endpoint;
    protected final PascalByteString senderCertificate;
    protected final PascalByteString receiverCertificateThumbprint;

    @Override
    public Boolean getResponse() {
        return false;
    }

    public OpenChannelMessageRequest(int secureChannelId, PascalString endpoint, PascalByteString senderCertificate, PascalByteString receiverCertificateThumbprint) {
        this.secureChannelId = secureChannelId;
        this.endpoint = endpoint;
        this.senderCertificate = senderCertificate;
        this.receiverCertificateThumbprint = receiverCertificateThumbprint;
    }

    public int getSecureChannelId() {
        return this.secureChannelId;
    }

    public PascalString getEndpoint() {
        return this.endpoint;
    }

    public PascalByteString getSenderCertificate() {
        return this.senderCertificate;
    }

    public PascalByteString getReceiverCertificateThumbprint() {
        return this.receiverCertificateThumbprint;
    }

    @Override
    protected void serializeOpenChannelMessageChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("OpenChannelMessageRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("secureChannelId", this.secureChannelId, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("endpoint", this.endpoint, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("senderCertificate", this.senderCertificate, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("receiverCertificateThumbprint", this.receiverCertificateThumbprint, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("OpenChannelMessageRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        OpenChannelMessageRequest _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += this.endpoint.getLengthInBits();
        lengthInBits += this.senderCertificate.getLengthInBits();
        return lengthInBits += this.receiverCertificateThumbprint.getLengthInBits();
    }

    public static OpenChannelMessage.OpenChannelMessageBuilder staticParseOpenChannelMessageBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("OpenChannelMessageRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int secureChannelId = FieldReaderFactory.readSimpleField("secureChannelId", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        PascalString endpoint = FieldReaderFactory.readSimpleField("endpoint", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        PascalByteString senderCertificate = FieldReaderFactory.readSimpleField("senderCertificate", new DataReaderComplexDefault<PascalByteString>(() -> PascalByteString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        PascalByteString receiverCertificateThumbprint = FieldReaderFactory.readSimpleField("receiverCertificateThumbprint", new DataReaderComplexDefault<PascalByteString>(() -> PascalByteString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("OpenChannelMessageRequest", new WithReaderArgs[0]);
        return new OpenChannelMessageRequestBuilderImpl(secureChannelId, endpoint, senderCertificate, receiverCertificateThumbprint);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenChannelMessageRequest)) {
            return false;
        }
        OpenChannelMessageRequest that = (OpenChannelMessageRequest)o;
        return this.getSecureChannelId() == that.getSecureChannelId() && this.getEndpoint() == that.getEndpoint() && this.getSenderCertificate() == that.getSenderCertificate() && this.getReceiverCertificateThumbprint() == that.getReceiverCertificateThumbprint() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSecureChannelId(), this.getEndpoint(), this.getSenderCertificate(), this.getReceiverCertificateThumbprint());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class OpenChannelMessageRequestBuilderImpl
    implements OpenChannelMessage.OpenChannelMessageBuilder {
        private final int secureChannelId;
        private final PascalString endpoint;
        private final PascalByteString senderCertificate;
        private final PascalByteString receiverCertificateThumbprint;

        public OpenChannelMessageRequestBuilderImpl(int secureChannelId, PascalString endpoint, PascalByteString senderCertificate, PascalByteString receiverCertificateThumbprint) {
            this.secureChannelId = secureChannelId;
            this.endpoint = endpoint;
            this.senderCertificate = senderCertificate;
            this.receiverCertificateThumbprint = receiverCertificateThumbprint;
        }

        @Override
        public OpenChannelMessageRequest build() {
            OpenChannelMessageRequest openChannelMessageRequest = new OpenChannelMessageRequest(this.secureChannelId, this.endpoint, this.senderCertificate, this.receiverCertificateThumbprint);
            return openChannelMessageRequest;
        }
    }
}

