/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.opcua.readwrite.BinaryPayload;
import org.apache.plc4x.java.opcua.readwrite.ExtensiblePayload;
import org.apache.plc4x.java.opcua.readwrite.SequenceHeader;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.EvaluationHelper;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public abstract class Payload
implements Message {
    protected final SequenceHeader sequenceHeader;

    public abstract Boolean getExtensible();

    public Payload(SequenceHeader sequenceHeader) {
        this.sequenceHeader = sequenceHeader;
    }

    public SequenceHeader getSequenceHeader() {
        return this.sequenceHeader;
    }

    protected abstract void serializePayloadChild(WriteBuffer var1) throws SerializationException;

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("Payload", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("sequenceHeader", this.sequenceHeader, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        this.serializePayloadChild(writeBuffer);
        writeBuffer.popContext("Payload", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        Payload _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        return lengthInBits += this.sequenceHeader.getLengthInBits();
    }

    public static Payload staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        Long byteCount;
        Boolean extensible;
        ReadBuffer positionAware = readBuffer;
        if (args == null || args.length != 2) {
            throw new PlcRuntimeException("Wrong number of arguments, expected 2, but got " + args.length);
        }
        if (args[0] instanceof Boolean) {
            extensible = (Boolean)args[0];
        } else if (args[0] instanceof String) {
            extensible = Boolean.valueOf((String)args[0]);
        } else {
            throw new PlcRuntimeException("Argument 0 expected to be of type Boolean or a string which is parseable but was " + args[0].getClass().getName());
        }
        if (args[1] instanceof Long) {
            byteCount = (Long)args[1];
        } else if (args[1] instanceof String) {
            byteCount = Long.valueOf((String)args[1]);
        } else {
            throw new PlcRuntimeException("Argument 1 expected to be of type Long or a string which is parseable but was " + args[1].getClass().getName());
        }
        return Payload.staticParse(readBuffer, extensible, byteCount);
    }

    public static Payload staticParse(ReadBuffer readBuffer, Boolean extensible, Long byteCount) throws ParseException {
        readBuffer.pullContext("Payload", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        SequenceHeader sequenceHeader = FieldReaderFactory.readSimpleField("sequenceHeader", new DataReaderComplexDefault<SequenceHeader>(() -> SequenceHeader.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        PayloadBuilder builder = null;
        if (EvaluationHelper.equals(extensible, true)) {
            builder = ExtensiblePayload.staticParsePayloadBuilder(readBuffer, extensible, byteCount);
        } else if (EvaluationHelper.equals(extensible, false)) {
            builder = BinaryPayload.staticParsePayloadBuilder(readBuffer, extensible, byteCount);
        }
        if (builder == null) {
            throw new ParseException("Unsupported case for discriminated type parameters [extensible=" + extensible + "]");
        }
        readBuffer.closeContext("Payload", new WithReaderArgs[0]);
        Payload _payload = builder.build(sequenceHeader);
        return _payload;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Payload)) {
            return false;
        }
        Payload that = (Payload)o;
        return this.getSequenceHeader() == that.getSequenceHeader();
    }

    public int hashCode() {
        return Objects.hash(this.getSequenceHeader());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static interface PayloadBuilder {
        public Payload build(SequenceHeader var1);
    }
}

