/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class RegisterNodesResponse
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition responseHeader;
    protected final int noOfRegisteredNodeIds;
    protected final List<NodeId> registeredNodeIds;

    @Override
    public String getIdentifier() {
        return "563";
    }

    public RegisterNodesResponse(ExtensionObjectDefinition responseHeader, int noOfRegisteredNodeIds, List<NodeId> registeredNodeIds) {
        this.responseHeader = responseHeader;
        this.noOfRegisteredNodeIds = noOfRegisteredNodeIds;
        this.registeredNodeIds = registeredNodeIds;
    }

    public ExtensionObjectDefinition getResponseHeader() {
        return this.responseHeader;
    }

    public int getNoOfRegisteredNodeIds() {
        return this.noOfRegisteredNodeIds;
    }

    public List<NodeId> getRegisteredNodeIds() {
        return this.registeredNodeIds;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("RegisterNodesResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("responseHeader", this.responseHeader, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfRegisteredNodeIds", this.noOfRegisteredNodeIds, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("registeredNodeIds", this.registeredNodeIds, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("RegisterNodesResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        RegisterNodesResponse _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.responseHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.registeredNodeIds != null) {
            int i = 0;
            for (NodeId element : this.registeredNodeIds) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.registeredNodeIds.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("RegisterNodesResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObjectDefinition responseHeader = FieldReaderFactory.readSimpleField("responseHeader", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "394"), readBuffer), new WithReaderArgs[0]);
        int noOfRegisteredNodeIds = FieldReaderFactory.readSimpleField("noOfRegisteredNodeIds", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<NodeId> registeredNodeIds = FieldReaderFactory.readCountArrayField("registeredNodeIds", new DataReaderComplexDefault<NodeId>(() -> NodeId.staticParse(readBuffer), readBuffer), noOfRegisteredNodeIds, new WithReaderArgs[0]);
        readBuffer.closeContext("RegisterNodesResponse", new WithReaderArgs[0]);
        return new RegisterNodesResponseBuilderImpl(responseHeader, noOfRegisteredNodeIds, registeredNodeIds);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegisterNodesResponse)) {
            return false;
        }
        RegisterNodesResponse that = (RegisterNodesResponse)o;
        return this.getResponseHeader() == that.getResponseHeader() && this.getNoOfRegisteredNodeIds() == that.getNoOfRegisteredNodeIds() && this.getRegisteredNodeIds() == that.getRegisteredNodeIds() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getResponseHeader(), this.getNoOfRegisteredNodeIds(), this.getRegisteredNodeIds());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class RegisterNodesResponseBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition responseHeader;
        private final int noOfRegisteredNodeIds;
        private final List<NodeId> registeredNodeIds;

        public RegisterNodesResponseBuilderImpl(ExtensionObjectDefinition responseHeader, int noOfRegisteredNodeIds, List<NodeId> registeredNodeIds) {
            this.responseHeader = responseHeader;
            this.noOfRegisteredNodeIds = noOfRegisteredNodeIds;
            this.registeredNodeIds = registeredNodeIds;
        }

        @Override
        public RegisterNodesResponse build() {
            RegisterNodesResponse registerNodesResponse = new RegisterNodesResponse(this.responseHeader, this.noOfRegisteredNodeIds, this.registeredNodeIds);
            return registerNodesResponse;
        }
    }
}

