/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DiagnosticInfo;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.StatusCode;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class RegisterServer2Response
extends ExtensionObjectDefinition
implements Message {
    protected final ExtensionObjectDefinition responseHeader;
    protected final int noOfConfigurationResults;
    protected final List<StatusCode> configurationResults;
    protected final int noOfDiagnosticInfos;
    protected final List<DiagnosticInfo> diagnosticInfos;

    @Override
    public String getIdentifier() {
        return "12196";
    }

    public RegisterServer2Response(ExtensionObjectDefinition responseHeader, int noOfConfigurationResults, List<StatusCode> configurationResults, int noOfDiagnosticInfos, List<DiagnosticInfo> diagnosticInfos) {
        this.responseHeader = responseHeader;
        this.noOfConfigurationResults = noOfConfigurationResults;
        this.configurationResults = configurationResults;
        this.noOfDiagnosticInfos = noOfDiagnosticInfos;
        this.diagnosticInfos = diagnosticInfos;
    }

    public ExtensionObjectDefinition getResponseHeader() {
        return this.responseHeader;
    }

    public int getNoOfConfigurationResults() {
        return this.noOfConfigurationResults;
    }

    public List<StatusCode> getConfigurationResults() {
        return this.configurationResults;
    }

    public int getNoOfDiagnosticInfos() {
        return this.noOfDiagnosticInfos;
    }

    public List<DiagnosticInfo> getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("RegisterServer2Response", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("responseHeader", this.responseHeader, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfConfigurationResults", this.noOfConfigurationResults, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("configurationResults", this.configurationResults, writeBuffer, new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("noOfDiagnosticInfos", this.noOfDiagnosticInfos, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField("diagnosticInfos", this.diagnosticInfos, writeBuffer, new WithWriterArgs[0]);
        writeBuffer.popContext("RegisterServer2Response", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        RegisterServer2Response _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.responseHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.configurationResults != null) {
            i = 0;
            for (StatusCode statusCode : this.configurationResults) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.configurationResults.size());
                lengthInBits += statusCode.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.diagnosticInfos != null) {
            i = 0;
            for (DiagnosticInfo diagnosticInfo : this.diagnosticInfos) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.diagnosticInfos.size());
                lengthInBits += diagnosticInfo.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("RegisterServer2Response", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        ExtensionObjectDefinition responseHeader = FieldReaderFactory.readSimpleField("responseHeader", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "394"), readBuffer), new WithReaderArgs[0]);
        int noOfConfigurationResults = FieldReaderFactory.readSimpleField("noOfConfigurationResults", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<StatusCode> configurationResults = FieldReaderFactory.readCountArrayField("configurationResults", new DataReaderComplexDefault<StatusCode>(() -> StatusCode.staticParse(readBuffer), readBuffer), noOfConfigurationResults, new WithReaderArgs[0]);
        int noOfDiagnosticInfos = FieldReaderFactory.readSimpleField("noOfDiagnosticInfos", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        List<DiagnosticInfo> diagnosticInfos = FieldReaderFactory.readCountArrayField("diagnosticInfos", new DataReaderComplexDefault<DiagnosticInfo>(() -> DiagnosticInfo.staticParse(readBuffer), readBuffer), noOfDiagnosticInfos, new WithReaderArgs[0]);
        readBuffer.closeContext("RegisterServer2Response", new WithReaderArgs[0]);
        return new RegisterServer2ResponseBuilderImpl(responseHeader, noOfConfigurationResults, configurationResults, noOfDiagnosticInfos, diagnosticInfos);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegisterServer2Response)) {
            return false;
        }
        RegisterServer2Response that = (RegisterServer2Response)o;
        return this.getResponseHeader() == that.getResponseHeader() && this.getNoOfConfigurationResults() == that.getNoOfConfigurationResults() && this.getConfigurationResults() == that.getConfigurationResults() && this.getNoOfDiagnosticInfos() == that.getNoOfDiagnosticInfos() && this.getDiagnosticInfos() == that.getDiagnosticInfos() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getResponseHeader(), this.getNoOfConfigurationResults(), this.getConfigurationResults(), this.getNoOfDiagnosticInfos(), this.getDiagnosticInfos());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class RegisterServer2ResponseBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ExtensionObjectDefinition responseHeader;
        private final int noOfConfigurationResults;
        private final List<StatusCode> configurationResults;
        private final int noOfDiagnosticInfos;
        private final List<DiagnosticInfo> diagnosticInfos;

        public RegisterServer2ResponseBuilderImpl(ExtensionObjectDefinition responseHeader, int noOfConfigurationResults, List<StatusCode> configurationResults, int noOfDiagnosticInfos, List<DiagnosticInfo> diagnosticInfos) {
            this.responseHeader = responseHeader;
            this.noOfConfigurationResults = noOfConfigurationResults;
            this.configurationResults = configurationResults;
            this.noOfDiagnosticInfos = noOfDiagnosticInfos;
            this.diagnosticInfos = diagnosticInfos;
        }

        @Override
        public RegisterServer2Response build() {
            RegisterServer2Response registerServer2Response = new RegisterServer2Response(this.responseHeader, this.noOfConfigurationResults, this.configurationResults, this.noOfDiagnosticInfos, this.diagnosticInfos);
            return registerServer2Response;
        }
    }
}

