/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class SequenceHeader
implements Message {
    protected final int sequenceNumber;
    protected final int requestId;

    public SequenceHeader(int sequenceNumber, int requestId) {
        this.sequenceNumber = sequenceNumber;
        this.requestId = requestId;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int getRequestId() {
        return this.requestId;
    }

    @Override
    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("SequenceHeader", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("sequenceNumber", this.sequenceNumber, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("requestId", this.requestId, DataWriterFactory.writeSignedInt(writeBuffer, 32), new WithWriterArgs[0]);
        writeBuffer.popContext("SequenceHeader", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = 0;
        SequenceHeader _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        return lengthInBits += 32;
    }

    public static SequenceHeader staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return SequenceHeader.staticParse(readBuffer);
    }

    public static SequenceHeader staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("SequenceHeader", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        int sequenceNumber = FieldReaderFactory.readSimpleField("sequenceNumber", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        int requestId = FieldReaderFactory.readSimpleField("requestId", DataReaderFactory.readSignedInt(readBuffer, 32), new WithReaderArgs[0]);
        readBuffer.closeContext("SequenceHeader", new WithReaderArgs[0]);
        SequenceHeader _sequenceHeader = new SequenceHeader(sequenceNumber, requestId);
        return _sequenceHeader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SequenceHeader)) {
            return false;
        }
        SequenceHeader that = (SequenceHeader)o;
        return this.getSequenceNumber() == that.getSequenceNumber() && this.getRequestId() == that.getRequestId();
    }

    public int hashCode() {
        return Objects.hash(this.getSequenceNumber(), this.getRequestId());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

