/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.LocalizedText;
import org.apache.plc4x.java.opcua.readwrite.ServerState;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterEnumDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class ServerStatusDataType
extends ExtensionObjectDefinition
implements Message {
    protected final long startTime;
    protected final long currentTime;
    protected final ServerState state;
    protected final ExtensionObjectDefinition buildInfo;
    protected final long secondsTillShutdown;
    protected final LocalizedText shutdownReason;

    @Override
    public String getIdentifier() {
        return "864";
    }

    public ServerStatusDataType(long startTime, long currentTime, ServerState state, ExtensionObjectDefinition buildInfo, long secondsTillShutdown, LocalizedText shutdownReason) {
        this.startTime = startTime;
        this.currentTime = currentTime;
        this.state = state;
        this.buildInfo = buildInfo;
        this.secondsTillShutdown = secondsTillShutdown;
        this.shutdownReason = shutdownReason;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getCurrentTime() {
        return this.currentTime;
    }

    public ServerState getState() {
        return this.state;
    }

    public ExtensionObjectDefinition getBuildInfo() {
        return this.buildInfo;
    }

    public long getSecondsTillShutdown() {
        return this.secondsTillShutdown;
    }

    public LocalizedText getShutdownReason() {
        return this.shutdownReason;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ServerStatusDataType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("startTime", this.startTime, DataWriterFactory.writeSignedLong(writeBuffer, 64), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("currentTime", this.currentTime, DataWriterFactory.writeSignedLong(writeBuffer, 64), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField("state", "ServerState", this.state, new DataWriterEnumDefault<ServerState, Long>(ServerState::getValue, Enum::name, DataWriterFactory.writeUnsignedLong(writeBuffer, 32)), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("buildInfo", this.buildInfo, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("secondsTillShutdown", this.secondsTillShutdown, DataWriterFactory.writeUnsignedLong(writeBuffer, 32), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("shutdownReason", this.shutdownReason, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("ServerStatusDataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ServerStatusDataType _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 64;
        lengthInBits += 64;
        lengthInBits += 32;
        lengthInBits += this.buildInfo.getLengthInBits();
        lengthInBits += 32;
        return lengthInBits += this.shutdownReason.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("ServerStatusDataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        long startTime = FieldReaderFactory.readSimpleField("startTime", DataReaderFactory.readSignedLong(readBuffer, 64), new WithReaderArgs[0]);
        long currentTime = FieldReaderFactory.readSimpleField("currentTime", DataReaderFactory.readSignedLong(readBuffer, 64), new WithReaderArgs[0]);
        ServerState state = (ServerState)((Object)FieldReaderFactory.readEnumField("state", "ServerState", new DataReaderEnumDefault<ServerState, Long>(ServerState::enumForValue, DataReaderFactory.readUnsignedLong(readBuffer, 32)), new WithReaderArgs[0]));
        ExtensionObjectDefinition buildInfo = FieldReaderFactory.readSimpleField("buildInfo", new DataReaderComplexDefault<ExtensionObjectDefinition>(() -> ExtensionObjectDefinition.staticParse(readBuffer, "340"), readBuffer), new WithReaderArgs[0]);
        long secondsTillShutdown = FieldReaderFactory.readSimpleField("secondsTillShutdown", DataReaderFactory.readUnsignedLong(readBuffer, 32), new WithReaderArgs[0]);
        LocalizedText shutdownReason = FieldReaderFactory.readSimpleField("shutdownReason", new DataReaderComplexDefault<LocalizedText>(() -> LocalizedText.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("ServerStatusDataType", new WithReaderArgs[0]);
        return new ServerStatusDataTypeBuilderImpl(startTime, currentTime, state, buildInfo, secondsTillShutdown, shutdownReason);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerStatusDataType)) {
            return false;
        }
        ServerStatusDataType that = (ServerStatusDataType)o;
        return this.getStartTime() == that.getStartTime() && this.getCurrentTime() == that.getCurrentTime() && this.getState() == that.getState() && this.getBuildInfo() == that.getBuildInfo() && this.getSecondsTillShutdown() == that.getSecondsTillShutdown() && this.getShutdownReason() == that.getShutdownReason() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getStartTime(), this.getCurrentTime(), this.getState(), this.getBuildInfo(), this.getSecondsTillShutdown(), this.getShutdownReason()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ServerStatusDataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final long startTime;
        private final long currentTime;
        private final ServerState state;
        private final ExtensionObjectDefinition buildInfo;
        private final long secondsTillShutdown;
        private final LocalizedText shutdownReason;

        public ServerStatusDataTypeBuilderImpl(long startTime, long currentTime, ServerState state, ExtensionObjectDefinition buildInfo, long secondsTillShutdown, LocalizedText shutdownReason) {
            this.startTime = startTime;
            this.currentTime = currentTime;
            this.state = state;
            this.buildInfo = buildInfo;
            this.secondsTillShutdown = secondsTillShutdown;
            this.shutdownReason = shutdownReason;
        }

        @Override
        public ServerStatusDataType build() {
            ServerStatusDataType serverStatusDataType = new ServerStatusDataType(this.startTime, this.currentTime, this.state, this.buildInfo, this.secondsTillShutdown, this.shutdownReason);
            return serverStatusDataType;
        }
    }
}

