/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;

public class SignatureData
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString algorithm;
    protected final PascalByteString signature;

    @Override
    public String getIdentifier() {
        return "458";
    }

    public SignatureData(PascalString algorithm, PascalByteString signature) {
        this.algorithm = algorithm;
        this.signature = signature;
    }

    public PascalString getAlgorithm() {
        return this.algorithm;
    }

    public PascalByteString getSignature() {
        return this.signature;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("SignatureData", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("algorithm", this.algorithm, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField("signature", this.signature, new DataWriterComplexDefault(writeBuffer), new WithWriterArgs[0]);
        writeBuffer.popContext("SignatureData", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        SignatureData _value = this;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.algorithm.getLengthInBits();
        return lengthInBits += this.signature.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, String identifier) throws ParseException {
        readBuffer.pullContext("SignatureData", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString algorithm = FieldReaderFactory.readSimpleField("algorithm", new DataReaderComplexDefault<PascalString>(() -> PascalString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        PascalByteString signature = FieldReaderFactory.readSimpleField("signature", new DataReaderComplexDefault<PascalByteString>(() -> PascalByteString.staticParse(readBuffer), readBuffer), new WithReaderArgs[0]);
        readBuffer.closeContext("SignatureData", new WithReaderArgs[0]);
        return new SignatureDataBuilderImpl(algorithm, signature);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SignatureData)) {
            return false;
        }
        SignatureData that = (SignatureData)o;
        return this.getAlgorithm() == that.getAlgorithm() && this.getSignature() == that.getSignature() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAlgorithm(), this.getSignature());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable(this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class SignatureDataBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString algorithm;
        private final PascalByteString signature;

        public SignatureDataBuilderImpl(PascalString algorithm, PascalByteString signature) {
            this.algorithm = algorithm;
            this.signature = signature;
        }

        @Override
        public SignatureData build() {
            SignatureData signatureData = new SignatureData(this.algorithm, this.signature);
            return signatureData;
        }
    }
}

